/*
 * Decompiled with CFR 0.152.
 */
package ch.abertschi.sct.xstream.path;

import ch.abertschi.sct.xstream.exclusion.ReaderContext;
import ch.abertschi.sct.xstream.path.PathTracker;
import com.thoughtworks.xstream.converters.ErrorWriter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.ReaderWrapper;

public class PathTrackerReader
extends ReaderWrapper {
    private PathTracker pathTracker;
    private ReaderContext context;

    public PathTrackerReader(HierarchicalStreamReader reader, ReaderContext context) {
        super(reader);
        this.context = context;
        if (context.getPathTrackerContext() != null) {
            this.pathTracker = context.getPathTrackerContext().getTracker();
        }
        if (this.isActive()) {
            this.pathTracker.pushElement(this.getNodeName());
        }
    }

    public void moveDown() {
        super.moveDown();
        if (this.isActive()) {
            this.pathTracker.pushElement(this.getNodeName());
        }
    }

    public void moveUp() {
        super.moveUp();
        if (this.isActive()) {
            this.pathTracker.popElement();
        }
    }

    public void appendErrors(ErrorWriter errorWriter) {
        errorWriter.add("path", this.pathTracker.getPath().toString());
        super.appendErrors(errorWriter);
    }

    protected boolean isActive() {
        if (this.context.getPathTrackerContext() != null) {
            return this.context.getPathTrackerContext().isActive();
        }
        return false;
    }
}

