/*
 * Decompiled with CFR 0.152.
 */
package ch.abertschi.sct.xstream.exclusion;

import ch.abertschi.sct.xstream.exclusion.FieldExclusionWriterMatcher;
import ch.abertschi.sct.xstream.path.PathTrackerContext;
import com.thoughtworks.xstream.io.path.Path;
import java.util.LinkedList;
import java.util.List;

public class WriterContext {
    private PathTrackerContext pathTrackerContext;
    private List<Path> exclusions = new LinkedList<Path>();
    private List<FieldExclusionWriterMatcher> exclusionMatchers = new LinkedList<FieldExclusionWriterMatcher>();

    public WriterContext() {
        this.exclusionMatchers.add(new FieldExclusionWriterMatcher.FieldExclusionWriterMatcherDefault());
    }

    public boolean isCurrentElementExcluded() {
        Path current = this.pathTrackerContext.getTracker().getPath();
        boolean success = false;
        for (FieldExclusionWriterMatcher matcher : this.exclusionMatchers) {
            if (!matcher.doesExclusionMatchForCurrent(current, this.exclusions)) continue;
            success = true;
            break;
        }
        return success;
    }

    public List<Path> getExclusions() {
        return this.exclusions;
    }

    public void setExclusions(List<Path> exclusions) {
        this.exclusions = exclusions;
    }

    public List<FieldExclusionWriterMatcher> getExclusionMatchers() {
        return this.exclusionMatchers;
    }

    public void setExclusionMatchers(List<FieldExclusionWriterMatcher> exclusionMatchers) {
        this.exclusionMatchers = exclusionMatchers;
    }

    public void addExclusionMatcher(FieldExclusionWriterMatcher exclusionMatcher) {
        this.exclusionMatchers.add(exclusionMatcher);
    }

    public PathTrackerContext getPathTrackerContext() {
        return this.pathTrackerContext;
    }

    public void setPathTrackerContext(PathTrackerContext pathTrackerContext) {
        this.pathTrackerContext = pathTrackerContext;
    }
}

