/*
 * Decompiled with CFR 0.152.
 */
package ch.abertschi.sct.xstream.exclusion;

import ch.abertschi.sct.util.SctException;
import ch.abertschi.sct.xstream.exclusion.ReaderContext;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.ReaderWrapper;

public class FieldExclusionReader
extends ReaderWrapper {
    private static final String EXCLUDE_STR = "%ANY%";
    private ReaderContext context;

    public FieldExclusionReader(HierarchicalStreamReader reader, ReaderContext context) {
        super(reader);
        this.context = context;
    }

    public String getValue() {
        String s = super.getValue();
        if (EXCLUDE_STR.equals(s)) {
            if (null == this.context.getFieldType()) {
                throw new SctException("No reflection information is available for current value " + s);
            }
            if (this.context != null) {
                this.context.getExclusions().add(this.context.getPathTrackerContext().getTracker().getPath());
            }
            s = new PureJavaReflectionProvider().newInstance(this.context.getFieldType()).toString();
            this.context.setFieldType(null);
        }
        return s;
    }

    public HierarchicalStreamReader underlyingReader() {
        return this;
    }

    public ReaderContext getContext() {
        return this.context;
    }
}

