/*
 * Decompiled with CFR 0.152.
 */
package ch.abertschi.sct.xstream.converter;

import ch.abertschi.sct.xstream.exclusion.FieldExclusionReader;
import ch.abertschi.sct.xstream.exclusion.FieldExclusionWriter;
import ch.abertschi.sct.xstream.exclusion.ReaderContext;
import ch.abertschi.sct.xstream.exclusion.WriterContext;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExclusionReflectionConverter
extends ReflectionConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ExclusionReflectionConverter.class);
    private static final String EXCLUSION_READER_CTX = "EXCL_READ_CTX";
    private static final String EXCLUSION_WRITER_CTX = "EXCL_WRTR_CTX";

    public ExclusionReflectionConverter(Mapper mapper, ReflectionProvider reflectionProvider) {
        super(mapper, reflectionProvider);
    }

    public boolean canConvert(Class type) {
        return super.canConvert(type);
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        if (reader.underlyingReader() instanceof FieldExclusionReader) {
            FieldExclusionReader exclusionReader = (FieldExclusionReader)reader.underlyingReader();
            context.put((Object)EXCLUSION_READER_CTX, (Object)exclusionReader.getContext());
        }
        return super.unmarshal(reader, context);
    }

    protected Object unmarshallField(UnmarshallingContext context, Object result, Class type, Field field) {
        ReaderContext readerContext = (ReaderContext)context.get((Object)EXCLUSION_READER_CTX);
        if (readerContext != null) {
            readerContext.setFieldType(type);
            LOG.trace("Reflection information for field {} provied", (Object)type);
        }
        Object unmarshalledField = super.unmarshallField(context, result, type, field);
        LOG.trace(readerContext.getPathTrackerContext().getTracker().getPath().toString());
        return unmarshalledField;
    }

    public void marshal(Object original, HierarchicalStreamWriter writer, MarshallingContext context) {
        if (writer.underlyingWriter() instanceof FieldExclusionWriter) {
            FieldExclusionWriter exclusionWriter = (FieldExclusionWriter)writer.underlyingWriter();
            context.put((Object)EXCLUSION_WRITER_CTX, (Object)exclusionWriter.getContext());
        }
        super.marshal(original, writer, context);
    }

    protected void marshallField(MarshallingContext context, Object newObj, Field field) {
        WriterContext writerContext = (WriterContext)context.get((Object)EXCLUSION_WRITER_CTX);
        if (writerContext != null) {
            LOG.trace(writerContext.getPathTrackerContext().getTracker().getPath().toString());
        }
        super.marshallField(context, newObj, field);
    }
}

