/*
 * Decompiled with CFR 0.152.
 */
package ch.abertschi.sct.xstream.converter;

import ch.abertschi.sct.call.CallObject;
import ch.abertschi.sct.xstream.converter.ConverterWrapper;
import ch.abertschi.sct.xstream.exclusion.FieldExclusionReader;
import ch.abertschi.sct.xstream.exclusion.FieldExclusionWriter;
import ch.abertschi.sct.xstream.exclusion.ReaderContext;
import ch.abertschi.sct.xstream.exclusion.WriterContext;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.path.Path;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallObjectConverter
extends ConverterWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(CallObjectConverter.class);

    public CallObjectConverter(Converter converter) {
        super(converter);
    }

    @Override
    public boolean canConvert(Class type) {
        return type.isAssignableFrom(CallObject.class);
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        CallObject callObj = null;
        if (reader.underlyingReader() instanceof FieldExclusionReader) {
            FieldExclusionReader exclusionReader = (FieldExclusionReader)reader.underlyingReader();
            ReaderContext ctx = exclusionReader.getContext();
            ctx.setExclusions(new LinkedList<Path>());
            ctx.getPathTrackerContext().startTracker();
            LOG.debug("Umarshaling known field CallObject");
            callObj = (CallObject)super.unmarshal((HierarchicalStreamReader)exclusionReader, context);
            ctx.getPathTrackerContext().stopTracker();
            LOG.debug("{} exclusion filters parsed.", (Object)(ctx.getExclusions() != null ? ctx.getExclusions().size() : 0));
            callObj.setFieldExclusion(ctx.getExclusions());
        } else {
            callObj = (CallObject)super.unmarshal(reader, context);
        }
        return callObj;
    }

    @Override
    public void marshal(Object original, HierarchicalStreamWriter writer, MarshallingContext context) {
        CallObject callObj = (CallObject)original;
        if (writer.underlyingWriter() instanceof FieldExclusionWriter) {
            FieldExclusionWriter exclusionWriter = (FieldExclusionWriter)writer.underlyingWriter();
            WriterContext ctx = exclusionWriter.getContext();
            ctx.setExclusions(callObj.getFieldExclusion());
            LOG.debug("Marshalling known field CallObject using {} exclusion filters.", (Object)(ctx.getExclusions() != null ? ctx.getExclusions().size() : 0));
            ctx.getPathTrackerContext().startTracker();
            super.marshal(original, writer, context);
            ctx.getPathTrackerContext().stopTracker();
        } else {
            super.marshal(original, writer, context);
        }
    }
}

