/*
 * Decompiled with CFR 0.152.
 */
package ch.abertschi.sct.util;

import ch.abertschi.sct.util.ErrorContext;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SctException
extends RuntimeException
implements ErrorContext {
    private static final long serialVersionUID = 1L;
    private static final String SEPARATOR = "\n-------------------------------";
    private Map<String, List<String>> errorStuff = new HashMap<String, List<String>>();

    public SctException(String message, Throwable t) {
        super(message, t);
        if (message != null) {
            this.add("message", message);
        }
        if (t != null) {
            this.add("cause-exception", t.getClass().getName());
            this.add("cause-message", t instanceof SctException ? ((SctException)t).getShortMessage() : t.getMessage());
        }
    }

    public SctException(Exception e) {
        super(null, e);
    }

    public SctException(String s) {
        super(s, null);
    }

    @Override
    public void add(String name, String information) {
        List<Object> list = null;
        if (this.errorStuff.get(name) == null) {
            list = new LinkedList();
            this.errorStuff.put(name, list);
        } else {
            list = this.errorStuff.get(name);
        }
        list.add(information);
    }

    @Override
    public void set(String name, String information) {
        LinkedList<String> list = new LinkedList<String>();
        list.add(information);
        this.errorStuff.put(name, list);
    }

    @Override
    public String get(String errorKey) {
        return this.getAsSingleString(this.errorStuff.get(errorKey));
    }

    private String getAsSingleString(List<String> list) {
        StringBuilder build = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            build.append(list.get(i));
            build.append("[").append(i).append("]").append(";");
        }
        return build.toString();
    }

    @Override
    public Iterator<String> keys() {
        return this.errorStuff.keySet().iterator();
    }

    @Override
    public String getMessage() {
        StringBuffer result = new StringBuffer();
        if (super.getMessage() != null) {
            result.append(super.getMessage());
        }
        if (!result.toString().endsWith(SEPARATOR)) {
            result.append("\n---- sct debugging information ----");
        }
        Iterator<String> iterator = this.keys();
        while (iterator.hasNext()) {
            String k = iterator.next();
            String v = this.get(k);
            result.append('\n').append(k);
            result.append("                    ".substring(Math.min(20, k.length())));
            result.append(": ").append(v);
        }
        result.append(SEPARATOR);
        return result.toString();
    }

    public String getShortMessage() {
        return super.getMessage();
    }
}

