/*
 * Decompiled with CFR 0.152.
 */
package ch.abertschi.sct.call;

import ch.abertschi.sct.call.Call;
import ch.abertschi.sct.call.CallComparator;
import ch.abertschi.sct.call.CallObject;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.LinkedList;
import java.util.List;

@XStreamAlias(value="calls")
public class CallCollection {
    @XStreamImplicit
    private List<Call> collection;
    @XStreamOmitField
    private XStream xstream;

    public CallCollection(XStream xstream) {
        this(xstream, null);
    }

    public CallCollection(XStream xstream, List<Call> calls) {
        this.collection = this.createList(calls);
        this.xstream = xstream;
    }

    public void put(Object request, Object response) {
        CallObject reqObj = new CallObject(request);
        CallObject respObj = new CallObject(response);
        Call call = new Call(reqObj, respObj);
        this.collection.add(call);
    }

    public void add(Call call) {
        this.collection.add(call);
    }

    public boolean contains(Object request) {
        return this.get(request) != null;
    }

    public Object get(Object key) {
        CallComparator comparator = new CallComparator(this.xstream);
        for (Call call : this.collection) {
            if (!comparator.compareRequestWithCallObject(key, call.getRequest())) continue;
            return call.getResponse().getObject();
        }
        return null;
    }

    public List<Call> getCollection() {
        return this.collection;
    }

    public void setCollection(List<Call> collection) {
        this.collection = collection;
    }

    private List<Call> createList(List<Call> calls) {
        if (calls == null) {
            return new LinkedList<Call>();
        }
        return new LinkedList<Call>(calls);
    }
}

