/*
 * Decompiled with CFR 0.152.
 */
package ch.abertschi.sct;

import ch.abertschi.sct.Serializer;
import ch.abertschi.sct.util.SctException;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.StreamException;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializerImpl
implements Serializer {
    private static final Logger LOG = LoggerFactory.getLogger(SerializerImpl.class);
    private XStream xstream;

    public SerializerImpl(XStream xstream) {
        this.xstream = xstream;
    }

    @Override
    public <T> T unmarshal(URL where) {
        this.checkIfValidOrThrowException(where);
        Object unmarshalled = null;
        try {
            unmarshalled = this.xstream.fromXML(where.openStream());
        }
        catch (IOException e) {
            throw new SctException("Specified dataset was not found.", e);
        }
        catch (StreamException e) {
            LOG.info("Dataset for mocking record doesn't constist of any records or is invalid. Existing data will be ignored.");
        }
        return (T)unmarshalled;
    }

    @Override
    public <T> void marshal(T toMarshal, URL target) {
        this.checkIfValidOrThrowException(target);
        FileOutputStream writer = null;
        try {
            writer = new FileOutputStream(target.getFile(), false);
        }
        catch (FileNotFoundException e) {
            throw new SctException("Specified dataset was not found.", e);
        }
        try {
            this.xstream.toXML(toMarshal, (OutputStream)writer);
            writer.close();
        }
        catch (IOException e) {
            throw new SctException(e);
        }
    }

    private void checkIfValidOrThrowException(URL url) {
        if (url == null) {
            throw new SctException(String.format("Specified dataset is null", new Object[0]));
        }
    }
}

