/*
 * Decompiled with CFR 0.152.
 */
package ch.abertschi.sct;

import ch.abertschi.sct.CallPersistence;
import ch.abertschi.sct.CallPersistenceImpl;
import ch.abertschi.sct.SctContext;
import ch.abertschi.sct.api.SctConfiguration;
import ch.abertschi.sct.invocation.Interceptor;
import ch.abertschi.sct.invocation.InvocationContext;
import ch.abertschi.sct.util.ResultNotFoundExcetion;
import ch.abertschi.sct.util.SctException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SctInterceptor
implements Interceptor {
    private static final Logger LOG = LoggerFactory.getLogger(SctInterceptor.class);
    private CallPersistence boundary;
    private SctContext context;

    public SctInterceptor(SctConfiguration config) {
        this.context = this.createContext(config);
        this.boundary = new CallPersistenceImpl(this.context);
    }

    public SctInterceptor(SctConfiguration config, CallPersistence boundary) {
        this.context = this.createContext(config);
        this.boundary = boundary;
    }

    private SctContext createContext(SctConfiguration c) {
        SctContext context = new SctContext();
        context.setConfiguration(c);
        return context;
    }

    @Override
    public Object invoke(InvocationContext ctx) {
        Object request = this.getInCorrectDimension(ctx.getParameters());
        SctConfiguration config = this.context.getConfiguration();
        Object response = null;
        this.printHeader(request, config);
        if (config.isResponseLoading() && config.isCallRecording()) {
            LOG.info("Performing response loading and call recording action.");
            try {
                response = this.loadResponse(request);
            }
            catch (ResultNotFoundExcetion e) {
                response = this.proceed(ctx);
                LOG.info("Response doesn't exist yet. Calling native service to record call...");
                this.recordCall(request, response);
            }
        } else if (config.isResponseLoading()) {
            LOG.info("Performing response loading action.");
            try {
                response = this.loadResponse(request);
            }
            catch (ResultNotFoundExcetion e) {
                throw new SctException("No matching response was found. Canceling execution.", e);
            }
        } else if (config.isCallRecording()) {
            LOG.info("Performing call recording action.");
            response = this.proceed(ctx);
            this.recordCall(request, response);
        } else {
            LOG.info("sct-Interceptor is not activated for call. Delegating to native service.");
            response = this.proceed(ctx);
        }
        return response;
    }

    private Object loadResponse(Object request) throws ResultNotFoundExcetion {
        return this.boundary.load(request);
    }

    private void recordCall(Object request, Object response) {
        this.boundary.record(request, response);
    }

    private Object proceed(InvocationContext ctx) {
        try {
            return ctx.proceed();
        }
        catch (Exception e) {
            throw new SctException("Unable to proceed call to native subsystem. Something unexpected went wrong ...", e);
        }
    }

    private Object getInCorrectDimension(Object[] parameters) {
        Object result = null;
        if (parameters != null) {
            result = parameters.length > 1 ? parameters : parameters[0];
        }
        return result;
    }

    private void printHeader(Object request, SctConfiguration config) {
        String HEADER = "------ sct runtime information ------";
        String NEW_L = "\n";
        StringBuilder b = new StringBuilder();
        b.append("\n").append("------ sct runtime information ------").append("\n").append("configuration:\t").append(config).append("\n").append("request-object:\t").append(request);
        LOG.info(b.toString());
    }
}

