/*
 * Decompiled with CFR 0.152.
 */
package ch.abertschi.sct;

import ch.abertschi.sct.CallPersistence;
import ch.abertschi.sct.SctContext;
import ch.abertschi.sct.Serializer;
import ch.abertschi.sct.SerializerImpl;
import ch.abertschi.sct.api.SctConfiguration;
import ch.abertschi.sct.call.Call;
import ch.abertschi.sct.call.CallCollection;
import ch.abertschi.sct.xstream.XStreamProvider;
import com.thoughtworks.xstream.XStream;
import java.net.URL;
import java.util.List;

public class CallPersistenceImpl
implements CallPersistence {
    private Serializer service;
    private SctContext context;
    private XStream xstream = XStreamProvider.INSTANCE.createExclusionXStream();

    public CallPersistenceImpl(SctContext ctx) {
        this.service = new SerializerImpl(this.xstream);
        this.context = ctx;
    }

    @Override
    public Object load(Object in) {
        URL where = this.getConfig().getResponseLoadingUrl();
        CallCollection collection = new CallCollection(this.xstream, this.get(where));
        Object out = collection.get(in);
        if (out != null) {
            return out;
        }
        throw new RuntimeException("Response not found in stored calls");
    }

    @Override
    public void record(Object in, Object out) {
        URL where = this.getConfig().getCallRecordingUrl();
        CallCollection collection = new CallCollection(this.xstream, this.get(where));
        collection.put(in, out);
        this.service.marshal(collection, where);
    }

    protected List<Call> get(URL url) {
        CallCollection c = (CallCollection)this.service.unmarshal(url);
        return c != null ? c.getCollection() : null;
    }

    private SctConfiguration getConfig() {
        return this.context.getConfiguration();
    }
}

