/*
 * Decompiled with CFR 0.152.
 */
package ch.abertschi.sct.api;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class Configuration {
    private boolean throwExceptionOnNotFound = true;
    private boolean throwExceptionOnIncompatibleReturnType = true;
    private boolean recordingEnabled = false;
    private File recordingSource;
    private INPUT_SOURCE recordingSourceType = INPUT_SOURCE.SINGLE_FILE;
    private boolean recordingSkipDoubles = false;
    private RECORDING_MODE recordingMode = RECORDING_MODE.OVERWRITE;
    private Map<String, Class<?>> marshallInstructions = new HashMap();
    private boolean replayingEnabled = false;
    private URL replayingSource;
    private INPUT_SOURCE replayingSourceType = INPUT_SOURCE.SINGLE_FILE;

    public Map<String, Class<?>> getMarshallInstructions() {
        return this.marshallInstructions;
    }

    public Configuration setMarshallInstructions(Map<String, Class<?>> instructions) {
        this.marshallInstructions = instructions;
        return this;
    }

    public Configuration addMarshallInstruction(String alias, Class<?> type) {
        this.marshallInstructions.put(alias, type);
        return this;
    }

    public boolean isRecordingEnabled() {
        return this.recordingEnabled;
    }

    public Configuration setRecordingEnabled(boolean recordingEnabled) {
        this.recordingEnabled = recordingEnabled;
        return this;
    }

    public RECORDING_MODE getRecordingMode() {
        return this.recordingMode;
    }

    public Configuration setRecordingMode(RECORDING_MODE recordingMode) {
        this.recordingMode = recordingMode;
        return this;
    }

    public boolean isRecordingSkipDoubles() {
        return this.recordingSkipDoubles;
    }

    public Configuration setRecordingSkipDoubles(boolean recordingSkipDoubles) {
        this.recordingSkipDoubles = recordingSkipDoubles;
        return this;
    }

    public File getRecordingSource() {
        return this.recordingSource;
    }

    public Configuration setRecordingSource(File recordingSource) {
        this.recordingSource = recordingSource;
        return this;
    }

    public INPUT_SOURCE getRecordingSourceType() {
        return this.recordingSourceType;
    }

    public Configuration setRecordingSourceType(INPUT_SOURCE recordingSourceType) {
        this.recordingSourceType = recordingSourceType;
        return this;
    }

    public boolean isReplayingEnabled() {
        return this.replayingEnabled;
    }

    public Configuration setReplayingEnabled(boolean replayingEnabled) {
        this.replayingEnabled = replayingEnabled;
        return this;
    }

    public URL getReplayingSource() {
        return this.replayingSource;
    }

    public Configuration setReplayingSource(URL replayingSource) {
        this.replayingSource = replayingSource;
        return this;
    }

    public INPUT_SOURCE getReplayingSourceType() {
        return this.replayingSourceType;
    }

    public Configuration setReplayingSourceType(INPUT_SOURCE replayingSourceType) {
        this.replayingSourceType = replayingSourceType;
        return this;
    }

    public boolean isThrowExceptionOnNotFound() {
        return this.throwExceptionOnNotFound;
    }

    public Configuration setThrowExceptionOnNotFound(boolean throwExceptionOnNotFound) {
        this.throwExceptionOnNotFound = throwExceptionOnNotFound;
        return this;
    }

    public boolean isThrowExceptionOnIncompatibleReturnType() {
        return this.throwExceptionOnIncompatibleReturnType;
    }

    public Configuration setThrowExceptionOnIncompatibleReturnType(boolean throwExceptionOnIncompatibleReturnType) {
        this.throwExceptionOnIncompatibleReturnType = throwExceptionOnIncompatibleReturnType;
        return this;
    }

    public static enum INPUT_SOURCE {
        SINGLE_FILE,
        DIRECTORY;

    }

    public static enum RECORDING_MODE {
        DUMP_CALLS,
        OVERWRITE;

    }
}

