/*
 * Decompiled with CFR 0.152.
 */
package ch.abertschi.sct.aspect;

import ch.abertschi.sct.api.Configuration;
import ch.abertschi.sct.api.Interceptor;
import ch.abertschi.sct.api.SctConfigurator;
import ch.abertschi.sct.api.ServiceCallTrackerFactory;
import ch.abertschi.sct.api.invocation.DefaultInvocationContext;
import ch.abertschi.sct.api.invocation.InvocationContext;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SctBaseIntercepting {
    private static final Logger LOG = LoggerFactory.getLogger(SctBaseIntercepting.class);

    public Object aroundInvoke(ProceedingJoinPoint method) throws Throwable {
        Interceptor interc = this.createInterceptor(method);
        DefaultInvocationContext ctx = this.createContext(method, interc);
        return this.invoke(interc, (InvocationContext)ctx);
    }

    protected Interceptor createInterceptor(ProceedingJoinPoint method) {
        return ServiceCallTrackerFactory.lookupInterceptor((Configuration)this.getSctConfiguration());
    }

    protected DefaultInvocationContext createContext(final ProceedingJoinPoint joinPoint, Interceptor interceptor) {
        Callable<Object> proceed = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    return joinPoint.proceed();
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        };
        DefaultInvocationContext ctx = new DefaultInvocationContext((Callable)proceed);
        ctx.setParameters(joinPoint.getArgs());
        ctx.setProxy(joinPoint.getThis());
        ctx.setTarget(joinPoint.getTarget());
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        ctx.setMethod(method);
        return ctx;
    }

    protected Object invoke(Interceptor interceptor, InvocationContext ctx) {
        return interceptor.invoke(ctx);
    }

    protected Configuration getSctConfiguration() {
        return SctConfigurator.getInstance().getConfiguration();
    }
}

