/*
 * Decompiled with CFR 0.152.
 */
package ch.abertschi.sct.arquillian.client;

import ch.abertschi.sct.arquillian.ExtensionConfiguration;
import ch.abertschi.sct.arquillian.RecordTestConfiguration;
import ch.abertschi.sct.arquillian.ReplayTestConfiguration;
import ch.abertschi.sct.arquillian.TestClassScanner;
import ch.abertschi.sct.arquillian.annotation.RecordCallExtractor;
import ch.abertschi.sct.arquillian.annotation.RecordConfiguration;
import ch.abertschi.sct.arquillian.annotation.ReplayCallExtractor;
import ch.abertschi.sct.arquillian.annotation.ReplayConfiguration;
import ch.abertschi.sct.arquillian.api.RecordCall;
import ch.abertschi.sct.arquillian.api.ReplayCall;
import ch.abertschi.sct.arquillian.client.Descriptor;
import com.github.underscore.$;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.arquillian.container.test.spi.client.deployment.ApplicationArchiveProcessor;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.arquillian.test.spi.annotation.SuiteScoped;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.FileAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.container.LibraryContainer;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalArchiveProcessor
implements ApplicationArchiveProcessor {
    private static final String EXTENSION_JAR_NAME = "service-call-tracker-extension-resources.jar";
    private static final Logger LOG = LoggerFactory.getLogger(LocalArchiveProcessor.class);
    private File recordingStorage;
    private File replayingStorage;
    private File sourceBase;
    @Inject
    @SuiteScoped
    InstanceProducer<LocalArchiveProcessor> instanceProducer;
    @Inject
    Instance<Descriptor> descriptor;

    public void before(@Observes(precedence=50) BeforeClass before) {
        this.instanceProducer.set((Object)this);
    }

    private void init() {
        this.replayingStorage = new File(new File("."), ((Descriptor)this.descriptor.get()).getProperty("replayingStorageDirectory"));
        this.recordingStorage = new File(new File("."), ((Descriptor)this.descriptor.get()).getProperty("recordingStorageDirectory"));
        this.sourceBase = new File(new File("."), ((Descriptor)this.descriptor.get()).getProperty("sourceDirectory"));
    }

    public void process(Archive<?> applicationArchive, TestClass testClass) {
        if (!((Descriptor)this.descriptor.get()).getBooleanProperty("enabled")) {
            return;
        }
        if (((Descriptor)this.descriptor.get()).getProperty("sourceDirectory") == null) {
            throw new IllegalArgumentException("Source Directory for service call tracker is not set in arquillian.xml");
        }
        this.init();
        if (((Descriptor)this.descriptor.get()).getBooleanProperty("useSuiteExtension")) {
            List classes = TestClassScanner.GET.findTestClassAnnotatedBy(RecordCall.class);
            classes.addAll(TestClassScanner.GET.findTestClassAnnotatedBy(ReplayCall.class));
            ArrayList added = new ArrayList();
            classes = $.filter(classes, c -> {
                if (added.contains(c.getName())) {
                    return false;
                }
                added.add(c.getName());
                return true;
            });
            classes.forEach(javaClass -> this.processTestClass(applicationArchive, (TestClass)javaClass));
        } else {
            this.processTestClass(applicationArchive, testClass);
        }
        System.out.println("@BEAN END LOCAL ARCHIVE PROCESSOR");
    }

    private void processTestClass(Archive<?> applicationArchive, TestClass testClass) {
        ExtensionConfiguration configuration = new ExtensionConfiguration();
        if (((Descriptor)this.descriptor.get()).getBooleanProperty("replayingEnabled")) {
            ReplayTestConfiguration replay = this.extractReplaying(testClass);
            this.addReplayingFilesToArchive(applicationArchive, replay);
            configuration.setReplayConfigurations(Arrays.asList(replay));
        }
        if (((Descriptor)this.descriptor.get()).getBooleanProperty("recordingEnabled")) {
            configuration.setRecordConfigurations(Arrays.asList(this.extractRecording(testClass)));
        }
        JavaArchive jar = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)EXTENSION_JAR_NAME);
        jar.add((Asset)new StringAsset(configuration.toXml()), "/META-INF/sct/service-call-tracker-config.xml");
        this.merge(applicationArchive, (Archive)jar);
    }

    private RecordTestConfiguration extractRecording(TestClass testClass) {
        RecordCallExtractor recordExtractor = new RecordCallExtractor(this.recordingStorage);
        RecordConfiguration recordClassConfig = recordExtractor.extractClassConfiguration(testClass);
        List<RecordConfiguration> recordMethodConfigs = recordExtractor.extractMethodConfigurations(testClass);
        return new RecordTestConfiguration(testClass.getJavaClass()).setMethodConfigurations(recordMethodConfigs).setClassConfiguration(recordClassConfig);
    }

    private ReplayTestConfiguration extractReplaying(TestClass testClass) {
        System.out.println(((Descriptor)this.descriptor.get()).getProperty("sourceDirectory"));
        System.out.println(this.sourceBase.getAbsolutePath());
        System.out.println(this.replayingStorage.getAbsolutePath());
        ReplayCallExtractor replayExtractor = new ReplayCallExtractor(this.sourceBase, this.replayingStorage);
        ReplayConfiguration replayClassConfig = replayExtractor.extractClassConfiguration(testClass);
        List<ReplayConfiguration> replayMethodConfigs = replayExtractor.extractMethodConfigurations(testClass);
        return new ReplayTestConfiguration(testClass.getJavaClass()).setMethodConfigurations(replayMethodConfigs).setClassConfiguration(replayClassConfig);
    }

    private void addReplayingFilesToArchive(Archive rootArchive, ReplayTestConfiguration config) {
        ArrayList<ReplayConfiguration> replayings = new ArrayList<ReplayConfiguration>();
        if (!$.isEmpty(config.getMethodConfigurations())) {
            replayings.addAll(config.getMethodConfigurations());
        }
        if (config.getClassConfiguration() != null) {
            replayings.add(config.getClassConfiguration());
        }
        JavaArchive resources = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
        $.forEach(replayings, r -> {
            resources.add((Asset)new FileAsset(new File(r.getPath())), r.getOrigin());
            r.setPath(r.getOrigin());
        });
        this.merge(rootArchive, (Archive)resources);
    }

    private void merge(Archive rootArchive, Archive toAdd) {
        if (JavaArchive.class.isInstance(rootArchive)) {
            rootArchive.merge(toAdd);
        } else {
            LibraryContainer libraryContainer = (LibraryContainer)rootArchive;
            libraryContainer.addAsLibrary(toAdd);
        }
    }
}

