/*
 * Decompiled with CFR 0.152.
 */
package ch.abertschi.sct.arquillian.annotation;

import ch.abertschi.sct.api.Configuration;
import java.lang.reflect.Method;

public class ReplayConfiguration {
    private boolean enabled;
    private String origin;
    private boolean throwExceptionOnNotFound;
    private boolean throwExceptionOnIncompatibleReturnType;
    private Configuration.INPUT_SOURCE sourceType;
    private String path;

    public ReplayConfiguration(Class<?> testClass, Method testMethod) {
        this.origin = this.createOrigin(testClass, testMethod);
    }

    private String createOrigin(Class<?> type, Method method) {
        return String.format("%s%s", type, method != null ? method.getName() : "");
    }

    public boolean isOrigin(Class<?> type, Method method) {
        return this.createOrigin(type, method).equals(this.origin);
    }

    public String getPath() {
        return this.path;
    }

    public ReplayConfiguration setPath(String path) {
        this.path = path;
        return this;
    }

    public boolean isThrowExceptionOnIncompatibleReturnType() {
        return this.throwExceptionOnIncompatibleReturnType;
    }

    public ReplayConfiguration setThrowExceptionOnIncompatibleReturnType(boolean throwExceptionOnIncompatibleReturnType) {
        this.throwExceptionOnIncompatibleReturnType = throwExceptionOnIncompatibleReturnType;
        return this;
    }

    public boolean isThrowExceptionOnNotFound() {
        return this.throwExceptionOnNotFound;
    }

    public ReplayConfiguration setThrowExceptionOnNotFound(boolean throwExceptionOnNotFound) {
        this.throwExceptionOnNotFound = throwExceptionOnNotFound;
        return this;
    }

    public String getOrigin() {
        return this.origin;
    }

    public ReplayConfiguration setOrigin(String origin) {
        this.origin = origin;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public ReplayConfiguration setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Configuration.INPUT_SOURCE getSourceType() {
        return this.sourceType;
    }

    public ReplayConfiguration setSourceType(Configuration.INPUT_SOURCE sourceType) {
        this.sourceType = sourceType;
        return this;
    }
}

