/*
 * Decompiled with CFR 0.152.
 */
package ch.abertschi.sct.arquillian.annotation;

import ch.abertschi.sct.arquillian.annotation.RecordConfiguration;
import ch.abertschi.sct.arquillian.api.RecordCall;
import com.github.underscore.$;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.jboss.arquillian.test.spi.TestClass;

public class RecordCallExtractor {
    private File storageBaseDir;

    public RecordCallExtractor(File storageBaseDir) {
        this.storageBaseDir = storageBaseDir;
    }

    public RecordConfiguration extractClassConfiguration(TestClass testClass) {
        return testClass.isAnnotationPresent(RecordCall.class) ? this.extractConfiguration(testClass.getJavaClass(), null, (RecordCall)testClass.getAnnotation(RecordCall.class)) : null;
    }

    public List<RecordConfiguration> extractMethodConfigurations(TestClass testClass) {
        return $.map(Arrays.asList(testClass.getMethods(RecordCall.class)), method -> this.extractConfiguration(testClass.getJavaClass(), (Method)method, method.getAnnotation(RecordCall.class)));
    }

    private RecordConfiguration extractConfiguration(Class<?> targetClass, Method targetMethod, RecordCall annotation) {
        String hint = annotation.value();
        if (hint == null || hint.isEmpty()) {
            String string = hint = targetMethod != null ? targetMethod.getName() : targetClass.getName();
        }
        if (!hint.endsWith(".xml")) {
            hint = hint.concat(".xml");
        }
        File file = new File(this.storageBaseDir, hint);
        return new RecordConfiguration(targetClass, targetMethod).setEnabled(annotation.enabled()).setPath(file.getAbsolutePath()).setSourceType(annotation.sourceType()).setMode(annotation.mode());
    }
}

