/*
 * Decompiled with CFR 0.152.
 */
package ch.abertschi.sct.arquillian.resolve;

import ch.abertschi.sct.arquillian.resolve.ResolverConfig;
import org.jboss.shrinkwrap.resolver.api.maven.ConfigurableMavenResolverSystem;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolverSystem;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.jboss.shrinkwrap.resolver.api.maven.PomEquippedResolveStage;
import org.jboss.shrinkwrap.resolver.api.maven.PomlessResolveStage;

public class ResolverUtil {
    private static ResolverUtil instance;
    private MavenResolverSystem mResolver;
    private PomEquippedResolveStage mPomEquippedResolver;

    public static ResolverUtil get() {
        if (instance == null) {
            instance = new ResolverUtil();
        }
        return instance;
    }

    private ResolverUtil() {
        if (ResolverConfig.isShrinkwrapResolveViaPlugin()) {
            this.mPomEquippedResolver = (PomEquippedResolveStage)((PomlessResolveStage)((MavenResolverSystem)((ConfigurableMavenResolverSystem)Maven.configureResolver().workOffline(ResolverConfig.isMavenOffline())).fromFile(ResolverConfig.getMavenExecutionGlobalSettings())).offline(ResolverConfig.isMavenOffline())).loadPomFromFile(ResolverConfig.getMavenExecutionPomFile());
        } else if (ResolverConfig.isShrinkwrapResolveViaPom()) {
            ConfigurableMavenResolverSystem resolver = Maven.configureResolver();
            if (ResolverConfig.isMavenOffline()) {
                resolver.workOffline();
            }
        } else {
            this.mResolver = Maven.resolver();
        }
    }

    public MavenStrategyStage resolve(String ... resolves) {
        if (ResolverConfig.isShrinkwrapResolveViaPlugin() || ResolverConfig.isShrinkwrapResolveViaPom()) {
            return (MavenStrategyStage)this.mPomEquippedResolver.resolve(resolves);
        }
        return (MavenStrategyStage)this.mResolver.resolve(resolves);
    }
}

