/*
 * Decompiled with CFR 0.152.
 */
package ch.abertschi.sct.arquillian.container;

import ch.abertschi.sct.arquillian.ExtensionConfiguration;
import ch.abertschi.sct.arquillian.annotation.RecordConfiguration;
import ch.abertschi.sct.arquillian.container.RemoteConfiguration;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.event.suite.BeforeSuite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteArchiveProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteArchiveProcessor.class);
    @Inject
    @ApplicationScoped
    private InstanceProducer<RemoteConfiguration> remoteConfigurationProducer;

    public void init(@Observes BeforeSuite suite) throws IOException {
        RemoteConfiguration remoteConfig = new RemoteConfiguration();
        ExtensionConfiguration config = this.loadConfiguration();
        this.prepareRecordingFiles(config);
        remoteConfig.setConfiguration(config);
        this.remoteConfigurationProducer.set((Object)remoteConfig);
    }

    private ExtensionConfiguration loadConfiguration() {
        ExtensionConfiguration config = null;
        try {
            String xml = IOUtils.toString((InputStream)Thread.currentThread().getContextClassLoader().getResource("/META-INF/sct/service-call-tracker-config.xml").openStream());
            if (xml != null || !xml.isEmpty()) {
                config = ExtensionConfiguration.fromXml(xml);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return config;
    }

    private void prepareRecordingFiles(ExtensionConfiguration config) throws IOException {
        for (RecordConfiguration recording : config.getAllRecordConfigurations()) {
            recording.setContainerPath(File.createTempFile(recording.getOrigin(), "").getAbsolutePath());
            LOG.info("Temp. recording file created {}", (Object)recording.getContainerPath());
        }
    }
}

