/*
 * Decompiled with CFR 0.152.
 */
package ch.abertschi.sct.arquillian;

import ch.abertschi.sct.arquillian.RecordTestConfiguration;
import ch.abertschi.sct.arquillian.ReplayTestConfiguration;
import ch.abertschi.sct.arquillian.annotation.RecordConfiguration;
import ch.abertschi.sct.arquillian.annotation.ReplayConfiguration;
import com.github.underscore.$;
import com.thoughtworks.xstream.XStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class ExtensionConfiguration {
    private List<RecordTestConfiguration> recordConfigurations = new ArrayList<RecordTestConfiguration>();
    private List<ReplayTestConfiguration> replayConfigurations = new ArrayList<ReplayTestConfiguration>();

    public List<RecordConfiguration> getAllRecordConfigurations() {
        ArrayList<RecordConfiguration> recordings = new ArrayList<RecordConfiguration>();
        for (RecordTestConfiguration testConfig : this.recordConfigurations) {
            if (testConfig.getClassConfiguration() != null) {
                recordings.add(testConfig.getClassConfiguration());
            }
            if ($.isEmpty(testConfig.getMethodConfigurations())) continue;
            recordings.addAll(testConfig.getMethodConfigurations());
        }
        return recordings;
    }

    public List<ReplayConfiguration> getAllReplayingConfigurations() {
        ArrayList<ReplayConfiguration> replayings = new ArrayList<ReplayConfiguration>();
        for (ReplayTestConfiguration testConfig : this.replayConfigurations) {
            if (testConfig.getClassConfiguration() != null) {
                replayings.add(testConfig.getClassConfiguration());
            }
            if ($.isEmpty(testConfig.getMethodConfigurations())) continue;
            replayings.addAll(testConfig.getMethodConfigurations());
        }
        return replayings;
    }

    public ReplayTestConfiguration getReplayTestConfiguration(Class<?> testClass) {
        List config = $.filter(this.replayConfigurations, replayConfig -> replayConfig.isTestClass(testClass));
        return $.isEmpty((Iterable)config) ? null : (ReplayTestConfiguration)config.get(0);
    }

    public RecordTestConfiguration getRecordTestConfiguration(Class<?> testClass) {
        List config = $.filter(this.recordConfigurations, recordConfig -> recordConfig.isTestClass(testClass));
        return $.isEmpty((Iterable)config) ? null : (RecordTestConfiguration)config.get(0);
    }

    public ReplayConfiguration getReplayConfiguration(Class<?> testClass, Method testMethod) {
        ReplayConfiguration result = null;
        ReplayTestConfiguration testConfig = this.getReplayTestConfiguration(testClass);
        if (testConfig != null) {
            ReplayConfiguration methodConfig = testConfig.getMethodConfiguration(testClass, testMethod);
            result = methodConfig != null ? methodConfig : testConfig.getClassConfiguration();
        }
        return result;
    }

    public RecordConfiguration getRecordConfiguration(Class<?> testClass, Method testMethod) {
        RecordConfiguration result = null;
        RecordTestConfiguration testConfig = this.getRecordTestConfiguration(testClass);
        if (testConfig != null) {
            RecordConfiguration methodConfig = testConfig.getMethodConfiguration(testClass, testMethod);
            result = methodConfig != null ? methodConfig : testConfig.getClassConfiguration();
        }
        return result;
    }

    public String toXml() {
        return new XStream().toXML((Object)this);
    }

    public static ExtensionConfiguration fromXml(String xml) {
        return (ExtensionConfiguration)new XStream().fromXML(xml);
    }

    public List<RecordTestConfiguration> getRecordConfigurations() {
        return this.recordConfigurations;
    }

    public ExtensionConfiguration setRecordConfigurations(List<RecordTestConfiguration> recordConfigurations) {
        this.recordConfigurations = recordConfigurations;
        return this;
    }

    public List<ReplayTestConfiguration> getReplayConfigurations() {
        return this.replayConfigurations;
    }

    public ExtensionConfiguration setReplayConfigurations(List<ReplayTestConfiguration> replayConfigurations) {
        this.replayConfigurations = replayConfigurations;
        return this;
    }
}

