/*
 * Decompiled with CFR 0.152.
 */
package ch.abertschi.arquillian.util;

import ch.abertschi.arquillian.util.ResolverConfig;
import org.jboss.shrinkwrap.resolver.api.maven.ConfigurableMavenResolverSystem;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolverSystem;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.jboss.shrinkwrap.resolver.api.maven.PomEquippedResolveStage;
import org.jboss.shrinkwrap.resolver.api.maven.PomlessResolveStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolverUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ResolverUtil.class);
    private static ResolverUtil instance;
    private MavenResolverSystem mResolver;
    private PomEquippedResolveStage mPomEquippedResolver;

    public static ResolverUtil get() {
        if (instance == null) {
            instance = new ResolverUtil();
        }
        return instance;
    }

    private ResolverUtil() {
        if (ResolverConfig.isShrinkwrapResolveViaPlugin()) {
            LOG.debug("Using maven configuration via Arquillian plugin");
            this.mPomEquippedResolver = (PomEquippedResolveStage)((PomlessResolveStage)((MavenResolverSystem)((ConfigurableMavenResolverSystem)Maven.configureResolver().workOffline(ResolverConfig.isMavenOffline())).fromFile(ResolverConfig.getMavenExecutionGlobalSettings())).offline(ResolverConfig.isMavenOffline())).loadPomFromFile(ResolverConfig.getMavenExecutionPomFile());
        } else if (ResolverConfig.isShrinkwrapResolveViaPom()) {
            ConfigurableMavenResolverSystem resolver = Maven.configureResolver();
            if (ResolverConfig.isMavenOffline()) {
                resolver.workOffline();
            }
        } else {
            this.mResolver = Maven.resolver();
        }
    }

    public PomEquippedResolveStage getBasePomResolver() {
        if (this.mPomEquippedResolver == null) {
            throw new RuntimeException("Pom based resolver not configured");
        }
        return this.mPomEquippedResolver;
    }

    public MavenStrategyStage resolve(String ... resolves) {
        if (ResolverConfig.isShrinkwrapResolveViaPlugin() || ResolverConfig.isShrinkwrapResolveViaPom()) {
            return (MavenStrategyStage)this.mPomEquippedResolver.resolve(resolves);
        }
        return (MavenStrategyStage)this.mResolver.resolve(resolves);
    }
}

