/*
 * Decompiled with CFR 0.152.
 */
package ch.abertschi.arquillian;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.GenericArchive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.importer.ZipImporter;

public class Cache {
    private static final String TEMP_DIR = "java.io.tmpdir";
    private static final String CACHE_DIR = "arquillian-aspectj-extention-cache";
    private static final String CACHE_INDEX = "cache-index.xml";
    private static final XStream XSTREAM = new XStream();
    private File cacheHomeDir;

    private Cache(File cacheFile) {
        this.cacheHomeDir = cacheFile;
    }

    public static Cache create(File location) {
        return new Cache(location);
    }

    public static Cache createWithDefaults() {
        String tmpDir = System.getProperty(TEMP_DIR);
        File cacheDir = new File(tmpDir, CACHE_DIR);
        cacheDir.mkdirs();
        return new Cache(cacheDir);
    }

    public File getCacheBaseDir() {
        return this.cacheHomeDir;
    }

    private File getCacheIndexFile() {
        return new File(this.cacheHomeDir, CACHE_INDEX);
    }

    public String getChecksum(Archive<?> archive) {
        try {
            return Integer.toString(IOUtils.toByteArray((InputStream)((ZipExporter)archive.as(ZipExporter.class)).exportAsInputStream()).length);
        }
        catch (IOException e) {
            throw new RuntimeException("Can not create checksum of archive " + archive.getName(), e);
        }
    }

    public Archive<?> getFromCache(Archive<?> keyArchive) {
        String checksum = this.getChecksum(keyArchive);
        Map<String, String> storage = this.loadCacheIndex();
        String cached = storage.get(checksum);
        if (cached == null) {
            return null;
        }
        File cachedFile = new File(cached);
        if (!cachedFile.exists()) {
            return null;
        }
        return (Archive)((ZipImporter)((ZipImporter)ShrinkWrap.create(ZipImporter.class)).importFrom(cachedFile)).as(GenericArchive.class);
    }

    public void storeInCache(Archive<?> keyArchive, Archive<?> archiveToCache) {
        String checksum = this.getChecksum(keyArchive);
        File persist = new File(this.getCacheBaseDir(), checksum + "-" + archiveToCache.getName());
        ((ZipExporter)archiveToCache.as(ZipExporter.class)).exportTo(persist, true);
        this.addToCacheIndex(checksum, persist.getAbsolutePath());
    }

    protected Map<String, String> loadCacheIndex() {
        Map<String, String> cacheIndex = new HashMap<String, String>();
        File cacheIndexFile = this.getCacheIndexFile();
        if (cacheIndexFile.exists()) {
            cacheIndex = (Map)XSTREAM.fromXML(cacheIndexFile);
        }
        return cacheIndex;
    }

    protected void addToCacheIndex(String key, String value) {
        Map<String, String> cacheIndex = this.loadCacheIndex();
        cacheIndex.put(key, value);
        File cacheIndexFile = this.getCacheIndexFile();
        try {
            FileOutputStream out = new FileOutputStream(cacheIndexFile);
            XSTREAM.toXML(cacheIndex, (OutputStream)out);
            out.close();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

