/*
 * Decompiled with CFR 0.152.
 */
package ch.abertschi.arquillian;

import ch.abertschi.arquillian.AjCompiler;
import ch.abertschi.arquillian.ArchiveProcessor$$Lambda$1;
import ch.abertschi.arquillian.ArchiveProcessor$$Lambda$2;
import ch.abertschi.arquillian.ArchiveProcessor$$Lambda$3;
import ch.abertschi.arquillian.ArchiveProcessor$$Lambda$4;
import ch.abertschi.arquillian.ArchiveSearch;
import ch.abertschi.arquillian.Cache;
import ch.abertschi.arquillian.descriptor.model.AspectLibrary;
import ch.abertschi.arquillian.descriptor.model.AspectjDescriptorModel;
import ch.abertschi.arquillian.descriptor.model.WeavingLibrary;
import ch.abertschi.arquillian.util.MatcherUtils;
import ch.abertschi.arquillian.util.ResolverUtil;
import com.github.underscore.$;
import com.github.underscore.Block;
import com.github.underscore.Function1;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.map.ObjectMapper;
import org.jboss.arquillian.container.test.spi.client.deployment.ApplicationArchiveProcessor;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveProcessor
implements ApplicationArchiveProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ArchiveProcessor.class);
    private static final String CONFIG_FILE = "/META-INF/aspectj.json";
    private static final AjCompiler COMPILER = new AjCompiler();
    private static final Cache CACHE = Cache.createWithDefaults();

    public void process(Archive<?> deployableArchive, TestClass testClass) {
        AspectjDescriptorModel model = this.getConfigurationFromArchive(deployableArchive);
        if (!$.isNull((Object)model)) {
            for (WeavingLibrary weavingDescriptor : model.getWeaving()) {
                List<WeavingLibrarySearchResult> weavingLibs = this.getWeavingLibraries(deployableArchive, weavingDescriptor);
                List<Archive<?>> aspects = this.getAspectLibraries(deployableArchive, weavingDescriptor.getAspects());
                for (WeavingLibrarySearchResult weavingLib : weavingLibs) {
                    Archive compiled = this.compile(weavingLib.getFilteredArchive(), aspects, weavingDescriptor);
                    $.forEach(compiled.getContent().entrySet(), (Block)ArchiveProcessor$$Lambda$1.lambdaFactory$());
                    compiled = this.mergeArchive(weavingLib.getSearchResult().getArchive(), compiled);
                    for (Archive aspect : $.concat(COMPILER.getRuntimeLibraries(), (Iterable[])new Iterable[]{aspects})) {
                        compiled = this.mergeArchive(compiled, aspect);
                    }
                    ArchiveSearch.replaceArchive(deployableArchive, weavingLib.getSearchResult().getPath(), compiled);
                }
            }
        }
    }

    private Archive<?> compile(Archive<?> source, List<Archive<?>> aspects, WeavingLibrary descriptor) {
        if (descriptor.isUseCache()) {
            Archive<?> cached = CACHE.getFromCache(source);
            if (cached == null) {
                LOG.info(String.format("Recompiling weaving library %s", source.getName()));
                Archive<?> compiled = COMPILER.compileTimeWeave(source, aspects);
                CACHE.storeInCache(source, compiled);
                return compiled;
            }
            LOG.info(String.format("Skipping aspectj compilation. Using cached archive %s from %s", source.getName(), CACHE.getCacheBaseDir()));
            return cached;
        }
        LOG.info(String.format("Recompiling weaving library %s", source.getName()));
        return COMPILER.compileTimeWeave(source, aspects);
    }

    private List<Archive<?>> getAspectLibraries(Archive<?> sourceArchive, List<AspectLibrary> aspectDescriptors) {
        ArrayList returns = new ArrayList();
        for (AspectLibrary aspectDescriptor : aspectDescriptors) {
            List aspects;
            if (aspectDescriptor.getName().contains(":")) {
                aspects = ((MavenFormatStage)ResolverUtil.get().resolve(aspectDescriptor.getName()).withTransitivity()).asList(JavaArchive.class);
            } else {
                String searchPattern = MatcherUtils.transformToMatchAnyParent(aspectDescriptor.getName());
                aspects = $.map(ArchiveSearch.searchInArchive(sourceArchive, searchPattern, false), (Function1)ArchiveProcessor$$Lambda$2.lambdaFactory$());
            }
            if ($.isEmpty((Iterable)aspects)) {
                String msg = String.format("aspect %s was neither found in deployable archive nor in maven repository", aspectDescriptor.getName());
                throw new RuntimeException(msg);
            }
            List<String> aspectIncludes = MatcherUtils.transformToMatchAnyChild(aspectDescriptor.getIncludes());
            List<String> aspectExcludes = MatcherUtils.transformToMatchAnyChild(aspectDescriptor.getExcludes());
            for (Archive aspect : aspects) {
                returns.add(ArchiveSearch.filterArchive(aspect, aspectIncludes, aspectExcludes));
            }
        }
        $.forEach(returns, (Block)ArchiveProcessor$$Lambda$3.lambdaFactory$());
        return Collections.unmodifiableList(returns);
    }

    private List<WeavingLibrarySearchResult> getWeavingLibraries(Archive<?> sourceArchive, WeavingLibrary weavingDescriptor) {
        String pattern = weavingDescriptor.isWeaveEverything() ? sourceArchive.getName() : MatcherUtils.transformToMatchAnyParent(weavingDescriptor.getName());
        List<ArchiveSearch.ArchiveSearchResult> searchResults = ArchiveSearch.searchInArchive(sourceArchive, pattern, false);
        ArrayList<WeavingLibrarySearchResult> weavingLibs = new ArrayList<WeavingLibrarySearchResult>();
        if (!$.isEmpty(searchResults)) {
            for (ArchiveSearch.ArchiveSearchResult searchResult : searchResults) {
                List<String> includes = MatcherUtils.transformToMatchAnyChild(weavingDescriptor.getIncludes());
                List<String> excludes = MatcherUtils.transformToMatchAnyChild(weavingDescriptor.getExcludes());
                Archive<?> filtered = ArchiveSearch.filterArchive(searchResult.getArchive(), includes, excludes);
                weavingLibs.add(new WeavingLibrarySearchResult().setFilteredArchive(filtered).setSearchResult(searchResult));
            }
        } else {
            String msg = String.format("Weaving %s could not be found in deployable", weavingDescriptor.getName());
            throw new RuntimeException(msg);
        }
        $.forEach(weavingLibs, (Block)ArchiveProcessor$$Lambda$4.lambdaFactory$());
        return Collections.unmodifiableList(weavingLibs);
    }

    private AspectjDescriptorModel getConfigurationFromArchive(Archive<?> archive) {
        Node configNode = archive.get(CONFIG_FILE);
        if (configNode != null) {
            String json;
            try {
                json = IOUtils.toString((InputStream)configNode.getAsset().openStream(), (String)"UTF-8");
                LOG.debug(json);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (json != null) {
                return this.parseConfiguration(json);
            }
        }
        return null;
    }

    private AspectjDescriptorModel parseConfiguration(String json) {
        AspectjDescriptorModel model = null;
        if (json != null) {
            ObjectMapper mapper = new ObjectMapper().setVisibility(JsonMethod.FIELD, JsonAutoDetect.Visibility.ANY);
            try {
                model = (AspectjDescriptorModel)mapper.readValue(json, AspectjDescriptorModel.class);
            }
            catch (IOException e) {
                throw new RuntimeException("Error in parsing aspectj.json", e);
            }
        }
        return model;
    }

    private boolean isWar(Archive archive) {
        return archive instanceof WebArchive;
    }

    private Archive mergeArchive(Archive container, Archive child) {
        container = this.isWar(container) ? container.merge(child, "/WEB-INF/classes") : container.merge(child);
        return container;
    }

    static /* synthetic */ void access$lambda$0(Map.Entry entry) {
        ArchiveProcessor.LOG.trace("Compiled node: " + entry.getKey());
    }

    static /* synthetic */ Archive access$lambda$1(ArchiveSearch.ArchiveSearchResult archiveSearchResult) {
        return archiveSearchResult.getArchive();
    }

    static /* synthetic */ void access$lambda$2(Archive archive) {
        ArchiveProcessor.LOG.info(String.format("Found aspect library %s", archive.getName()));
    }

    static /* synthetic */ void access$lambda$3(WeavingLibrarySearchResult weavingLibrarySearchResult) {
        ArchiveProcessor.LOG.info(String.format("Found weaving library %s", weavingLibrarySearchResult.getSearchResult().getPath()));
    }

    static class WeavingLibrarySearchResult {
        private ArchiveSearch.ArchiveSearchResult searchResult;
        private Archive<?> filteredArchive;

        WeavingLibrarySearchResult() {
        }

        public Archive<?> getFilteredArchive() {
            return this.filteredArchive;
        }

        public WeavingLibrarySearchResult setFilteredArchive(Archive<?> filteredArchive) {
            this.filteredArchive = filteredArchive;
            return this;
        }

        public ArchiveSearch.ArchiveSearchResult getSearchResult() {
            return this.searchResult;
        }

        public WeavingLibrarySearchResult setSearchResult(ArchiveSearch.ArchiveSearchResult searchResult) {
            this.searchResult = searchResult;
            return this;
        }
    }
}

