/*
 * Decompiled with CFR 0.152.
 */
package ch.aaap.harvestclient.impl;

import ch.aaap.harvestclient.api.TasksApi;
import ch.aaap.harvestclient.api.filter.TaskFilter;
import ch.aaap.harvestclient.domain.Task;
import ch.aaap.harvestclient.domain.pagination.PaginatedTask;
import ch.aaap.harvestclient.domain.param.TaskCreationInfo;
import ch.aaap.harvestclient.domain.param.TaskUpdateInfo;
import ch.aaap.harvestclient.domain.reference.Reference;
import ch.aaap.harvestclient.impl.ExceptionHandler;
import ch.aaap.harvestclient.service.TaskService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;

public class TasksApiImpl
implements TasksApi {
    private static final Logger log = LoggerFactory.getLogger(TasksApiImpl.class);
    private static final int PER_PAGE = 100;
    private TaskService service;

    public TasksApiImpl(TaskService service) {
        this.service = service;
    }

    @Override
    public List<Task> list(TaskFilter filter) {
        Integer nextPage = 1;
        ArrayList<Task> result = new ArrayList<Task>();
        while (nextPage != null) {
            log.debug("Getting page {} of Task list", (Object)nextPage);
            Map<String, Object> filterMap = filter.toMap();
            filterMap.put("page", nextPage);
            filterMap.put("per_page", 100);
            Call<PaginatedTask> call = this.service.list(filterMap);
            PaginatedTask pagination = ExceptionHandler.callOrThrow(call);
            result.addAll(pagination.getTasks());
            nextPage = pagination.getNextPage();
        }
        log.debug("Listed {} Task: {}", (Object)result.size(), result);
        return result;
    }

    @Override
    public Task get(Reference<Task> taskReference) {
        Call<Task> call = this.service.get(taskReference.getId());
        Task task = ExceptionHandler.callOrThrow(call);
        log.debug("Got {}", (Object)task);
        return task;
    }

    @Override
    public Task create(TaskCreationInfo creationInfo) {
        Call<Task> call = this.service.create(creationInfo);
        Task task = ExceptionHandler.callOrThrow(call);
        log.debug("Created {}", (Object)task);
        return task;
    }

    @Override
    public Task update(Reference<Task> taskReference, TaskUpdateInfo toChange) {
        log.debug("Updating {} with {}", taskReference, (Object)toChange);
        Call<Task> call = this.service.update(taskReference.getId(), toChange);
        return ExceptionHandler.callOrThrow(call);
    }

    @Override
    public void delete(Reference<Task> taskReference) {
        log.debug("Deleting {}", taskReference);
        Call<Void> call = this.service.delete(taskReference.getId());
        ExceptionHandler.callOrThrow(call);
    }
}

