/*
 * Decompiled with CFR 0.152.
 */
package ch.aaap.harvestclient.impl;

import ch.aaap.harvestclient.api.TaskAssignmentsApi;
import ch.aaap.harvestclient.api.filter.TaskAssignmentFilter;
import ch.aaap.harvestclient.domain.Project;
import ch.aaap.harvestclient.domain.TaskAssignment;
import ch.aaap.harvestclient.domain.pagination.PaginatedTaskAssignment;
import ch.aaap.harvestclient.domain.param.TaskAssignmentCreationInfo;
import ch.aaap.harvestclient.domain.param.TaskAssignmentUpdateInfo;
import ch.aaap.harvestclient.domain.reference.Reference;
import ch.aaap.harvestclient.impl.ExceptionHandler;
import ch.aaap.harvestclient.service.TaskAssignmentService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;

public class TaskAssignmentsApiImpl
implements TaskAssignmentsApi {
    private static final Logger log = LoggerFactory.getLogger(TaskAssignmentsApiImpl.class);
    private static final int PER_PAGE = 100;
    private TaskAssignmentService service;

    public TaskAssignmentsApiImpl(TaskAssignmentService service) {
        this.service = service;
    }

    @Override
    public List<TaskAssignment> list(Reference<Project> projectReference, TaskAssignmentFilter filter) {
        Integer nextPage = 1;
        ArrayList<TaskAssignment> result = new ArrayList<TaskAssignment>();
        while (nextPage != null) {
            log.debug("Getting page {} of TaskAssignment list", (Object)nextPage);
            Map<String, Object> filterMap = filter.toMap();
            filterMap.put("page", nextPage);
            filterMap.put("per_page", 100);
            Call<PaginatedTaskAssignment> call = this.service.list(projectReference.getId(), filterMap);
            PaginatedTaskAssignment pagination = ExceptionHandler.callOrThrow(call);
            result.addAll(pagination.getTaskAssignments());
            nextPage = pagination.getNextPage();
        }
        log.debug("Listed {} TaskAssignment: {}", (Object)result.size(), result);
        return result;
    }

    @Override
    public TaskAssignment get(Reference<Project> projectReference, Reference<TaskAssignment> taskAssignmentReference) {
        Call<TaskAssignment> call = this.service.get(projectReference.getId(), taskAssignmentReference.getId());
        TaskAssignment taskAssignment = ExceptionHandler.callOrThrow(call);
        log.debug("Gotten {}", (Object)taskAssignment);
        return taskAssignment;
    }

    @Override
    public TaskAssignment create(Reference<Project> projectReference, TaskAssignmentCreationInfo creationInfo) {
        Call<TaskAssignment> call = this.service.create(projectReference.getId(), creationInfo);
        TaskAssignment taskAssignment = ExceptionHandler.callOrThrow(call);
        log.debug("Created {}", (Object)taskAssignment);
        return taskAssignment;
    }

    @Override
    public TaskAssignment update(Reference<Project> projectReference, Reference<TaskAssignment> taskAssignmentReference, TaskAssignmentUpdateInfo updateInfo) {
        Call<TaskAssignment> call = this.service.update(projectReference.getId(), taskAssignmentReference.getId(), updateInfo);
        TaskAssignment taskAssignment = ExceptionHandler.callOrThrow(call);
        log.debug("Updated {}", (Object)taskAssignment);
        return taskAssignment;
    }

    @Override
    public void delete(Reference<Project> projectReference, Reference<TaskAssignment> taskAssignmentReference) {
        log.debug("Deleting {} in Project {}", taskAssignmentReference, projectReference);
        Call<Void> call = this.service.delete(projectReference.getId(), taskAssignmentReference.getId());
        ExceptionHandler.callOrThrow(call);
    }
}

