/*
 * Decompiled with CFR 0.152.
 */
package ch.aaap.harvestclient.impl;

import ch.aaap.harvestclient.api.RolesApi;
import ch.aaap.harvestclient.domain.Role;
import ch.aaap.harvestclient.domain.User;
import ch.aaap.harvestclient.domain.pagination.PaginatedRole;
import ch.aaap.harvestclient.domain.param.RoleInfo;
import ch.aaap.harvestclient.domain.reference.Reference;
import ch.aaap.harvestclient.impl.ExceptionHandler;
import ch.aaap.harvestclient.service.RoleService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;

public class RolesApiImpl
implements RolesApi {
    private static final Logger log = LoggerFactory.getLogger(RolesApiImpl.class);
    private static final int PER_PAGE = 100;
    private final RoleService service;

    public RolesApiImpl(RoleService service) {
        this.service = service;
    }

    @Override
    public List<Role> list() {
        Integer nextPage = 1;
        ArrayList<Role> roles = new ArrayList<Role>();
        while (nextPage != null) {
            log.debug("Getting page {} of roles list", (Object)nextPage);
            Call<PaginatedRole> call = this.service.list(nextPage, 100);
            PaginatedRole paginatedRole = ExceptionHandler.callOrThrow(call);
            roles.addAll(paginatedRole.getRoles());
            nextPage = paginatedRole.getNextPage();
        }
        log.debug("Listed {} Roles: {}", (Object)roles.size(), roles);
        return roles;
    }

    @Override
    public Role get(Reference<Role> roleReference) {
        Call<Role> call = this.service.get(roleReference.getId());
        Role role = ExceptionHandler.callOrThrow(call);
        log.debug("Got Role {}", (Object)role);
        return role;
    }

    @Override
    public Role create(RoleInfo roleInfo) {
        Call<Role> call = this.service.create(roleInfo);
        Role role = ExceptionHandler.callOrThrow(call);
        log.debug("Created Role {}", (Object)role);
        return role;
    }

    @Override
    public Role update(Reference<Role> roleReference, RoleInfo toChange) {
        log.debug("Updating Role {} with {}", roleReference, (Object)toChange);
        Call<Role> call = this.service.update(roleReference.getId(), toChange);
        return ExceptionHandler.callOrThrow(call);
    }

    @Override
    public Role addUser(Reference<Role> roleReference, Reference<User> userReference) {
        Role role = this.get(roleReference);
        RoleInfo roleInfo = new RoleInfo(role.getName());
        List<Long> userIds = role.getUserIds().stream().map(Reference::getId).collect(Collectors.toList());
        userIds.add(userReference.getId());
        roleInfo.setUserIds(userIds);
        return this.update(roleReference, roleInfo);
    }

    @Override
    public Role removeUser(Reference<Role> roleReference, Reference<User> userReference) {
        Role role = this.get(roleReference);
        RoleInfo roleInfo = new RoleInfo(role.getName());
        List<Long> userIds = role.getUserIds().stream().map(Reference::getId).collect(Collectors.toList());
        userIds.remove(userReference.getId());
        roleInfo.setUserIds(userIds);
        return this.update(roleReference, roleInfo);
    }

    @Override
    public void delete(Reference<Role> roleReference) {
        log.debug("Deleting role {}", roleReference);
        Call<Void> call = this.service.delete(roleReference.getId());
        ExceptionHandler.callOrThrow(call);
    }
}

