/*
 * Decompiled with CFR 0.152.
 */
package ch.aaap.harvestclient.impl;

import ch.aaap.harvestclient.api.ProjectAssignmentsApi;
import ch.aaap.harvestclient.domain.ProjectAssignment;
import ch.aaap.harvestclient.domain.User;
import ch.aaap.harvestclient.domain.pagination.PaginatedProjectAssignment;
import ch.aaap.harvestclient.domain.reference.Reference;
import ch.aaap.harvestclient.impl.ExceptionHandler;
import ch.aaap.harvestclient.service.ProjectAssignmentService;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;

public class ProjectAssignmentsApiImpl
implements ProjectAssignmentsApi {
    private static final Logger log = LoggerFactory.getLogger(ProjectAssignmentsApiImpl.class);
    private static final int PER_PAGE = 100;
    private ProjectAssignmentService service;

    public ProjectAssignmentsApiImpl(ProjectAssignmentService service) {
        this.service = service;
    }

    @Override
    public List<ProjectAssignment> list(Reference<User> userReference, Instant updatedSince) {
        Integer nextPage = 1;
        ArrayList<ProjectAssignment> projectAssignments = new ArrayList<ProjectAssignment>();
        while (nextPage != null) {
            log.debug("Getting page {} of project assigment list for user {}", (Object)nextPage, userReference);
            Call<PaginatedProjectAssignment> call = this.service.list(userReference.getId(), updatedSince, nextPage, 100);
            PaginatedProjectAssignment paginatedProjectAssignment = ExceptionHandler.callOrThrow(call);
            projectAssignments.addAll(paginatedProjectAssignment.getProjectAssignments());
            nextPage = paginatedProjectAssignment.getNextPage();
        }
        log.debug("Listed {} ProjectAssignment: {}", (Object)projectAssignments.size(), projectAssignments);
        return projectAssignments;
    }

    @Override
    public List<ProjectAssignment> listSelf() {
        Integer nextPage = 1;
        ArrayList<ProjectAssignment> projectAssignments = new ArrayList<ProjectAssignment>();
        while (nextPage != null) {
            log.debug("Getting page {} of project assigment list for self", (Object)nextPage);
            Call<PaginatedProjectAssignment> call = this.service.list(nextPage, 100);
            PaginatedProjectAssignment paginatedProjectAssignment = ExceptionHandler.callOrThrow(call);
            projectAssignments.addAll(paginatedProjectAssignment.getProjectAssignments());
            nextPage = paginatedProjectAssignment.getNextPage();
        }
        log.debug("Listed {} ProjectAssignment: {}", (Object)projectAssignments.size(), projectAssignments);
        return projectAssignments;
    }
}

