/*
 * Decompiled with CFR 0.152.
 */
package ch.aaap.harvestclient.core;

import ch.aaap.harvestclient.api.TimesheetsApi;
import ch.aaap.harvestclient.api.UsersApi;
import ch.aaap.harvestclient.core.gson.GsonConfiguration;
import ch.aaap.harvestclient.impl.TimesheetsApiImpl;
import ch.aaap.harvestclient.impl.UsersApiImpl;
import ch.aaap.harvestclient.service.TimeEntryService;
import ch.aaap.harvestclient.service.UserService;
import com.google.gson.Gson;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class Harvest {
    private static final Logger log = LoggerFactory.getLogger(Harvest.class);
    private final String baseUrl;
    private final String authToken;
    private final String accountId;
    private final String userAgent;
    private TimesheetsApi timesheetsApi;
    private UsersApi usersApi;

    public Harvest(Config config) {
        config.checkValid(ConfigFactory.defaultReference(), new String[]{"harvest"});
        this.baseUrl = config.getString("harvest.baseUrl");
        this.userAgent = config.getString("harvest.userAgent");
        this.authToken = config.getString("harvest.auth.token");
        this.accountId = config.getString("harvest.auth.accountId");
        Interceptor debugInterceptor = this.initHttpLogging();
        Interceptor authenticationInterceptor = this.initAuthentication();
        OkHttpClient client = new OkHttpClient.Builder().addInterceptor(authenticationInterceptor).addInterceptor(debugInterceptor).build();
        Gson gson = GsonConfiguration.getConfiguration();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(this.baseUrl).client(client).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)gson)).build();
        TimeEntryService timeEntryService = (TimeEntryService)retrofit.create(TimeEntryService.class);
        UserService userService = (UserService)retrofit.create(UserService.class);
        this.timesheetsApi = new TimesheetsApiImpl(timeEntryService);
        this.usersApi = new UsersApiImpl(userService);
        log.debug("Harvest client initialized");
    }

    public Harvest() {
        this(ConfigFactory.load());
    }

    private Interceptor initAuthentication() {
        return new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request.Builder ongoing = chain.request().newBuilder();
                ongoing.addHeader("Authorization", "Bearer " + Harvest.this.authToken);
                ongoing.addHeader("Harvest-Account-id", Harvest.this.accountId);
                ongoing.addHeader("User-Agent", Harvest.this.userAgent);
                return chain.proceed(ongoing.build());
            }
        };
    }

    private Interceptor initHttpLogging() {
        Logger httpLogger = LoggerFactory.getLogger((String)"okhttp");
        HttpLoggingInterceptor debugInterceptor = new HttpLoggingInterceptor(arg_0 -> ((Logger)httpLogger).trace(arg_0));
        debugInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        return debugInterceptor;
    }

    public TimesheetsApi timesheets() {
        return this.timesheetsApi;
    }

    public UsersApi users() {
        return this.usersApi;
    }
}

