/*
 * Decompiled with CFR 0.152.
 */
package ch.aaap.harvestclient.impl;

import ch.aaap.harvestclient.exception.ForbiddenException;
import ch.aaap.harvestclient.exception.HarvestHttpException;
import ch.aaap.harvestclient.exception.HarvestRuntimeException;
import ch.aaap.harvestclient.exception.InvalidAuthorizationException;
import ch.aaap.harvestclient.exception.NotFoundException;
import ch.aaap.harvestclient.exception.RateLimitedException;
import ch.aaap.harvestclient.exception.RequestProcessingException;
import ch.aaap.harvestclient.exception.ServerErrorException;
import java.io.IOException;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Response;

public class ExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(ExceptionHandler.class);

    public static <T> T callOrThrow(Call<T> call) {
        try {
            log.debug("Executing call {}", call);
            Response response = call.execute();
            if (response.isSuccessful()) {
                log.debug("Sucess");
                return (T)response.body();
            }
            int code = response.code();
            log.debug("Failure -> {}", (Object)code);
            ResponseBody errorBody = response.errorBody();
            switch (code) {
                case 401: {
                    throw new InvalidAuthorizationException(errorBody);
                }
                case 403: {
                    throw new ForbiddenException(errorBody);
                }
                case 404: {
                    throw new NotFoundException(errorBody);
                }
                case 422: {
                    throw new RequestProcessingException(errorBody);
                }
                case 429: {
                    throw new RateLimitedException(errorBody);
                }
                case 500: {
                    throw new ServerErrorException(errorBody, 500);
                }
            }
            throw new HarvestHttpException(errorBody, code);
        }
        catch (IOException e) {
            throw new HarvestRuntimeException(e);
        }
    }
}

