/*
 * Decompiled with CFR 0.152.
 */
package cc.kebei.expands.shell.build;

import cc.kebei.expands.shell.ShellBuilder;
import cc.kebei.utils.StringUtils;
import cc.kebei.utils.file.FileUtils;
import java.io.File;

public abstract class AbstractShellBuilder
implements ShellBuilder {
    protected String createFile(String text) throws Exception {
        String tmp = System.getProperty("java.io.tmpdir").concat("/cc/kebei/shell/");
        File file = new File(tmp);
        file.mkdirs();
        String timeStr = StringUtils.concat((Object[])new Object[]{"shell_", Math.abs(text.hashCode())});
        String shellFileName = timeStr + OsType.os.extension;
        String encode = OsType.os.encode;
        shellFileName = new File(file, shellFileName).getAbsolutePath();
        FileUtils.writeString2File((String)text, (String)shellFileName, (String)encode);
        return shellFileName;
    }

    static enum OsType {
        WINDOWS("gbk", ".bat"),
        LINUX("utf-8", ".sh"),
        MACOS("utf-8", ".sh");

        public final String encode;
        public final String extension;
        public static OsType os;

        private OsType(String encode, String extension) {
            this.encode = encode;
            this.extension = extension;
        }

        static {
            String osName = System.getProperty("os.name").toLowerCase();
            OsType now = null;
            if (osName.contains("win")) {
                now = WINDOWS;
            } else if (osName.contains("linux")) {
                now = LINUX;
            } else if (osName.contains("mac")) {
                now = MACOS;
            }
            os = now;
        }
    }
}

