/*
 * Decompiled with CFR 0.152.
 */
package cc.kebei.expands.shell;

import cc.kebei.expands.shell.Callback;
import cc.kebei.expands.shell.ProcessHelper;
import cc.kebei.expands.shell.Result;
import cc.kebei.expands.shell.ShellBuilder;
import cc.kebei.expands.shell.build.LinuxShellBuilder;
import cc.kebei.expands.shell.build.WindowsShellBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Consumer;

public class Shell {
    private static final String DEFAULT_ENCODE;
    private static ExecutorService executorService;
    private String encode;
    private List<String> env;
    private List<String> commands;
    private List<Callback> processCallback = new LinkedList<Callback>();
    private List<Callback> errorCallback = new LinkedList<Callback>();
    private List<Consumer<ProcessHelper>> execBeforeCallback = new LinkedList<Consumer<ProcessHelper>>();
    private static ShellBuilder shellBuilder;
    private boolean shutdown = false;
    private File dir;
    private ProcessHelper helper;
    private OutputStream stdin;

    public Shell(String command, String ... more) {
        this.encode = DEFAULT_ENCODE;
        this.commands = new ArrayList<String>(Arrays.asList(command));
        this.commands.addAll(Arrays.asList(more));
        this.dir = new File("./");
        this.helper = new ProcessHelper(){

            @Override
            public void kill() {
                Shell.this.shutdown = true;
            }

            @Override
            public void sendMessage(byte[] msg) throws IOException {
                if (null != Shell.this.stdin) {
                    Shell.this.stdin.write(msg);
                    Shell.this.stdin.flush();
                }
            }
        };
    }

    public static Shell build(String command, String ... more) {
        return new Shell(command, more);
    }

    public static Shell buildText(String text) throws Exception {
        return shellBuilder.buildTextShell(text);
    }

    public Shell dir(File file) {
        this.dir = file;
        return this;
    }

    public Shell dir(String dir) {
        return this.dir(new File(dir));
    }

    public Shell encode(String encode) {
        this.encode = encode;
        return this;
    }

    public Shell env(String ... env) {
        if (this.env == null) {
            this.env = Arrays.asList(env);
        } else {
            this.env.addAll(Arrays.asList(env));
        }
        return this;
    }

    public Shell onProcess(Callback callback) {
        this.processCallback.add(callback);
        return this;
    }

    public Shell onError(Callback callback) {
        this.errorCallback.add(callback);
        return this;
    }

    public Shell before(Consumer<ProcessHelper> consumer) {
        this.execBeforeCallback.add(consumer);
        return this;
    }

    public Result exec() throws IOException {
        if (this.commands.size() > 1) {
            String[] envp = this.env == null || this.env.isEmpty() ? new String[]{} : this.env.toArray(new String[this.env.size()]);
            Process process = Runtime.getRuntime().exec(this.commands.toArray(new String[this.commands.size()]), envp, this.dir);
            return this.process(process, this.encode);
        }
        Process process = Runtime.getRuntime().exec(this.commands.get(0));
        return this.process(process, this.encode);
    }

    public Future<Result> execAsyn() {
        return executorService.submit(this::exec);
    }

    public void execAsyn(Consumer<Result> consumer) {
        executorService.execute(() -> {
            try {
                consumer.accept(this.exec());
            }
            catch (IOException e) {
                consumer.accept(new Result(-1, e, e.getMessage()));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result process(Process process, String encode) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), encode));
            this.stdin = process.getOutputStream();
            new Thread(() -> {
                try {
                    String line;
                    BufferedReader errorStream = new BufferedReader(new InputStreamReader(process.getErrorStream(), encode));
                    while ((line = errorStream.readLine()) != null) {
                        if (this.shutdown) {
                            process.destroyForcibly();
                        }
                        String tmp = line;
                        this.errorCallback.forEach(consumer -> consumer.accept(tmp, this.helper));
                    }
                }
                catch (Exception e) {
                    this.errorCallback.forEach(consumer -> consumer.accept(e.getMessage(), this.helper));
                }
            }).start();
            this.execBeforeCallback.forEach(consumer -> consumer.accept(this.helper));
            while ((line = reader.readLine()) != null) {
                if (this.shutdown) {
                    process.destroyForcibly();
                }
                String tmp = line;
                this.processCallback.forEach(consumer -> consumer.accept(tmp, this.helper));
            }
            Result result = new Result(process.waitFor(), null, null);
            return result;
        }
        catch (Exception e) {
            this.errorCallback.forEach(consumer -> consumer.accept(e.getMessage(), this.helper));
            Result result = new Result(-1, e, e.getMessage());
            return result;
        }
        finally {
            this.stdin = null;
        }
    }

    static {
        executorService = Executors.newCachedThreadPool();
        String os = System.getProperty("os.name");
        if ("windows".equals(os.toLowerCase())) {
            DEFAULT_ENCODE = "gbk";
            shellBuilder = new WindowsShellBuilder();
        } else {
            DEFAULT_ENCODE = "utf-8";
            shellBuilder = new LinuxShellBuilder();
        }
    }
}

