/*
 * Decompiled with CFR 0.152.
 */
package cc.kebei.expands.security.rsa;

import cc.kebei.expands.security.rsa.RSAPrivateEncrypt;
import java.io.ByteArrayOutputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.spec.EncodedKeySpec;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;

public abstract class DefaultEncrypt {
    static final int MAX_ENCRYPT_BLOCK = 117;
    static final int MAX_DECRYPT_BLOCK = 128;
    static final String SIGNATURE_ALGORITHM = "MD5withRSA";

    protected abstract String getKey();

    protected abstract EncodedKeySpec encodedKeySpec(byte[] var1);

    public byte[] encrypt(byte[] data) {
        try {
            byte[] keyBytes = Base64.decodeBase64((String)this.getKey());
            EncodedKeySpec keySpec = this.encodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            Key key = this instanceof RSAPrivateEncrypt ? keyFactory.generatePrivate(keySpec) : keyFactory.generatePublic(keySpec);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(1, key);
            return this.doFinal(data, cipher, 117);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] doFinal(byte[] data, Cipher cipher, int max) throws Exception {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            int inputLen = data.length;
            int offSet = 0;
            int i = 0;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > max ? cipher.doFinal(data, offSet, max) : cipher.doFinal(data, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * max;
            }
            byte[] decryptedData = out.toByteArray();
            out.close();
            byte[] byArray = decryptedData;
            return byArray;
        }
    }

    public byte[] decrypt(byte[] data) {
        try {
            byte[] keyBytes = Base64.decodeBase64((String)this.getKey());
            EncodedKeySpec keySpec = this.encodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            Key key = this instanceof RSAPrivateEncrypt ? keyFactory.generatePrivate(keySpec) : keyFactory.generatePublic(keySpec);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(2, key);
            return this.doFinal(data, cipher, 128);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

