/*
 * Decompiled with CFR 0.152.
 */
package cc.kebei.expands.security.jwt;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SignatureException;
import io.jsonwebtoken.UnsupportedJwtException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;

public class TokenProvider {
    private static final Logger LOG = LoggerFactory.getLogger(TokenProvider.class);
    private static final String AUTHORITIES_KEY = "auth";
    private String secretKey;
    private long tokenValidityInMilliseconds = 86400L;
    private long tokenValidityInMillisecondsForRememberMe = 2592000L;

    private TokenProvider() {
    }

    public TokenProvider(String secretKey, long tokenValidityInMilliseconds, long tokenValidityInMillisecondsForRememberMe) {
        this.secretKey = secretKey;
        this.tokenValidityInMilliseconds = 1000L * tokenValidityInMilliseconds;
        this.tokenValidityInMillisecondsForRememberMe = 1000L * tokenValidityInMillisecondsForRememberMe;
    }

    public String createToken(Authentication authentication, boolean rememberMe) {
        String authorities = authentication.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.joining(","));
        long now = new Date().getTime();
        Date validity = rememberMe ? new Date(now + this.tokenValidityInMillisecondsForRememberMe) : new Date(now + this.tokenValidityInMilliseconds);
        return Jwts.builder().setSubject(authentication.getName()).claim(AUTHORITIES_KEY, (Object)authorities).signWith(SignatureAlgorithm.HS512, this.secretKey).setExpiration(validity).compact();
    }

    public Authentication getAuthentication(String token) {
        Claims claims = (Claims)Jwts.parser().setSigningKey(this.secretKey).parseClaimsJws(token).getBody();
        Collection authorities = Arrays.stream(claims.get((Object)AUTHORITIES_KEY).toString().split(",")).map(SimpleGrantedAuthority::new).collect(Collectors.toList());
        User principal = new User(claims.getSubject(), "", authorities);
        return new UsernamePasswordAuthenticationToken((Object)principal, (Object)token, authorities);
    }

    public boolean validateToken(String authToken) {
        try {
            Jwts.parser().setSigningKey(this.secretKey).parseClaimsJws(authToken);
            return true;
        }
        catch (SignatureException e) {
            LOG.info("Invalid JWT signature.");
            LOG.trace("Invalid JWT signature trace: {}", (Throwable)e);
        }
        catch (MalformedJwtException e) {
            LOG.info("Invalid JWT token.");
            LOG.trace("Invalid JWT token trace: {}", (Throwable)e);
        }
        catch (ExpiredJwtException e) {
            LOG.info("Expired JWT token.");
            LOG.trace("Expired JWT token trace: {}", (Throwable)e);
        }
        catch (UnsupportedJwtException e) {
            LOG.info("Unsupported JWT token.");
            LOG.trace("Unsupported JWT token trace: {}", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LOG.info("JWT token compact of handler are invalid.");
            LOG.trace("JWT token compact of handler are invalid trace: {}", (Throwable)e);
        }
        return false;
    }
}

