/*
 * Decompiled with CFR 0.152.
 */
package cc.kebei.expands.script.engine.java;

import cc.kebei.expands.script.engine.ExecuteResult;
import cc.kebei.expands.script.engine.ListenerSupportEngine;
import cc.kebei.expands.script.engine.ScriptContext;
import cc.kebei.expands.script.engine.java.CharSequenceJavaFileObject;
import cc.kebei.expands.script.engine.java.DynamicClassLoader;
import cc.kebei.expands.script.engine.java.Executor;
import cc.kebei.utils.ClassUtils;
import cc.kebei.utils.StringUtils;
import cc.kebei.utils.file.FileUtils;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.script.ScriptException;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaEngine
extends ListenerSupportEngine {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private String savePath = null;
    private String classpath = "";
    private Map<String, JavaCodeContext> cache = new ConcurrentHashMap<String, JavaCodeContext>();
    private URL[] loaderUrl;

    public JavaEngine() throws Exception {
        this.savePath = System.getProperty("java.io.tmpdir").concat("/cc/kebei/java/engine/");
        new File(this.savePath + "src").mkdirs();
        new File(this.savePath + "bin").mkdirs();
        this.classpath = System.getProperty("java.class.path");
        this.loaderUrl = new URL[]{new File(this.savePath + "bin").toURI().toURL()};
    }

    @Override
    public void init(String ... contents) throws Exception {
    }

    public String getClassName(String code) {
        String name = StringUtils.matcherFirst((String)"class\\s+([\\w\\d$_]+)s*", (String)code);
        if (name == null) {
            return name;
        }
        return name.substring(5, name.length()).trim();
    }

    public String getPackage(String code) {
        String name = StringUtils.matcherFirst((String)"package\\s+([\\w\\d$.]+)s*", (String)code);
        if (name == null) {
            return name;
        }
        return name.substring(7, name.length()).trim();
    }

    @Override
    public boolean compile(String id, String code) throws Exception {
        String name = this.getClassName(code);
        String packageName = this.getPackage(code);
        if (!StringUtils.isNullOrEmpty((Object)packageName)) {
            name = packageName + "." + name;
        }
        try {
            Class.forName(name);
            throw new UnsupportedOperationException("class " + name + " is exists!");
        }
        catch (ClassNotFoundException classNotFoundException) {
            JavaCompiler.CompilationTask task;
            boolean success;
            String fileName = this.savePath + "src/" + name.replace('.', '/') + ".java";
            File file = new File(fileName);
            if (file.exists()) {
                file.delete();
            }
            FileUtils.writeString2File((String)code, (String)fileName, (String)"utf-8");
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            DiagnosticCollector diagnostics = new DiagnosticCollector();
            ArrayList<CharSequenceJavaFileObject> jfiles = new ArrayList<CharSequenceJavaFileObject>();
            StandardJavaFileManager fm = compiler.getStandardFileManager(null, Locale.CHINA, Charset.forName("UTF-8"));
            jfiles.add(new CharSequenceJavaFileObject(this.savePath, name, code));
            ArrayList<String> options = new ArrayList<String>();
            options.add("-d");
            options.add(this.savePath + "bin");
            options.add("-cp");
            options.add(this.classpath);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("javac [{}] -> {}", (Object)fileName, options.stream().reduce((s, s2) -> s + " " + s2).get());
                this.logger.debug(code);
            }
            if (success = (task = compiler.getTask(null, fm, diagnostics, options, null, jfiles)).call().booleanValue()) {
                DynamicClassLoader dynamicClassLoader = new DynamicClassLoader(this.loaderUrl, JavaEngine.class.getClassLoader());
                Class<?> clazz = dynamicClassLoader.loadClass(name);
                Executor executor = null;
                if (ClassUtils.instanceOf(clazz, Executor.class)) {
                    executor = (Executor)clazz.newInstance();
                }
                JavaCodeContext context = new JavaCodeContext(id, DigestUtils.md5Hex((String)code), clazz, executor);
                this.cache.put(id, context);
                return clazz != null;
            }
            StringBuilder builder = new StringBuilder();
            for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
                builder.append(diagnostic).append("\n");
            }
            throw new ScriptException(builder.toString());
        }
    }

    @Override
    public ExecuteResult execute(String id) {
        return this.execute(id, new HashMap<String, Object>());
    }

    @Override
    public ExecuteResult execute(String id, Map<String, Object> param) {
        long startTime = System.currentTimeMillis();
        ExecuteResult result = new ExecuteResult();
        JavaCodeContext context = this.cache.get(id);
        try {
            if (context != null) {
                this.doListenerBefore(context);
                Executor executor = context.getExecutor();
                Class clazz = context.getCodeClass();
                if (executor != null) {
                    HashMap<String, Object> var = new HashMap<String, Object>(param);
                    var.putAll(this.getGlobalVariable());
                    result.setResult(executor.execute(var));
                    result.setSuccess(true);
                } else {
                    result.setSuccess(true);
                    result.setResult(clazz);
                }
            } else {
                result.setSuccess(false);
                result.setResult(null);
                result.setMessage(String.format("class(%s): %s not found!", id, "java"));
            }
        }
        catch (Exception e) {
            result.setException(e);
        }
        result.setUseTime(System.currentTimeMillis() - startTime);
        this.doListenerAfter(context, result);
        return result;
    }

    @Override
    public boolean remove(String id) {
        return this.cache.remove(id) != null;
    }

    @Override
    public boolean compiled(String id) {
        return this.cache.containsKey(id);
    }

    @Override
    public ScriptContext getContext(String id) {
        return this.cache.get(id);
    }

    protected class JavaCodeContext
    extends ScriptContext {
        private Class codeClass;
        private Executor executor;

        public JavaCodeContext(String id, String md5, Class codeClass, Executor executor) {
            super(id, md5);
            this.codeClass = codeClass;
            this.executor = executor;
        }

        public Class getCodeClass() {
            return this.codeClass;
        }

        public Executor getExecutor() {
            return this.executor;
        }
    }
}

