/*
 * Decompiled with CFR 0.152.
 */
package cc.kebei.expands.script.engine.common;

import cc.kebei.expands.script.engine.ExecuteResult;
import cc.kebei.expands.script.engine.ListenerSupportEngine;
import cc.kebei.expands.script.engine.ScriptContext;
import cc.kebei.expands.script.engine.ScriptListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonScriptEngine
extends ListenerSupportEngine {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Compilable compilable;
    protected Map<String, CommonScriptContext> scriptBase = new ConcurrentHashMap<String, CommonScriptContext>();
    protected Bindings utilBindings;
    protected List<ScriptListener> scriptListeners;

    public abstract String getScriptName();

    @Override
    public boolean compiled(String id) {
        return this.scriptBase.containsKey(id);
    }

    @Override
    public boolean remove(String id) {
        return this.scriptBase.remove(id) != null;
    }

    public CommonScriptEngine() {
        try {
            this.init(new String[0]);
        }
        catch (Exception e) {
            this.logger.warn("init {} error", (Object)this.getScriptName());
        }
    }

    @Override
    public void init(String ... contents) throws Exception {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName(this.getScriptName());
        this.compilable = (Compilable)((Object)engine);
        this.utilBindings = engine.createBindings();
        for (String content : contents) {
            CompiledScript script = this.compilable.compile(content);
            script.eval(this.utilBindings);
        }
    }

    @Override
    public ScriptContext getContext(String id) {
        return this.scriptBase.get(id);
    }

    @Override
    public boolean compile(String id, String code) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("compile {} {} : {}", new Object[]{this.getScriptName(), id, code});
        }
        if (this.compilable == null) {
            this.init(new String[0]);
        }
        CompiledScript compiledScript = this.compilable.compile(code);
        CommonScriptContext scriptContext = new CommonScriptContext(id, DigestUtils.md5Hex((String)code), compiledScript);
        this.scriptBase.put(id, scriptContext);
        return true;
    }

    @Override
    public void addListener(ScriptListener scriptListener) {
        if (this.scriptListeners == null) {
            this.scriptListeners = new LinkedList<ScriptListener>();
        }
        this.scriptListeners.add(scriptListener);
    }

    @Override
    public ExecuteResult execute(String id) {
        return this.execute(id, new HashMap<String, Object>());
    }

    @Override
    public ExecuteResult execute(String id, Map<String, Object> param) {
        long startTime = System.currentTimeMillis();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("execute {} {} : {}", (Object)this.getScriptName(), (Object)id);
        }
        ExecuteResult result = new ExecuteResult();
        CommonScriptContext scriptContext = this.scriptBase.get(id);
        try {
            if (scriptContext != null) {
                this.doListenerBefore(scriptContext);
                SimpleScriptContext context = new SimpleScriptContext();
                context.setBindings(this.utilBindings, 200);
                for (Map.Entry<String, Object> entry : param.entrySet()) {
                    context.setAttribute(entry.getKey(), entry.getValue(), 100);
                }
                result.setResult(scriptContext.getScript().eval(context));
                result.setSuccess(true);
            } else {
                result.setSuccess(false);
                result.setResult(null);
                result.setMessage(String.format("script(%s): %s not found!", this.getScriptName(), id));
            }
        }
        catch (ScriptException e) {
            result.setException(e);
        }
        result.setUseTime(System.currentTimeMillis() - startTime);
        this.doListenerAfter(scriptContext, result);
        return result;
    }

    @Override
    public void addGlobalVariable(Map<String, Object> vars) {
        this.utilBindings.putAll((Map<? extends String, ? extends Object>)vars);
    }

    public Bindings getUtilBindings() {
        return this.utilBindings;
    }

    public void setUtilBindings(Bindings utilBindings) {
        this.utilBindings = utilBindings;
    }

    protected class CommonScriptContext
    extends ScriptContext {
        private CompiledScript script;

        public CommonScriptContext(String id, String md5, CompiledScript script) {
            super(id, md5);
            this.script = script;
        }

        public CompiledScript getScript() {
            return this.script;
        }
    }
}

