/*
 * Decompiled with CFR 0.152.
 */
package cc.kebei.expands.script.engine;

import cc.kebei.expands.script.engine.DynamicScriptEngine;
import cc.kebei.expands.script.engine.SpEL.SpElEngine;
import cc.kebei.expands.script.engine.groovy.GroovyEngine;
import cc.kebei.expands.script.engine.java.JavaEngine;
import cc.kebei.expands.script.engine.js.JavaScriptEngine;
import cc.kebei.expands.script.engine.ognl.OgnlEngine;
import cc.kebei.expands.script.engine.python.PythonScriptEngine;
import cc.kebei.expands.script.engine.ruby.RubyScriptEngine;
import java.util.HashMap;
import java.util.Map;

public final class DynamicScriptEngineFactory {
    private static final Map<String, DynamicScriptEngine> map = new HashMap<String, DynamicScriptEngine>();

    public static final DynamicScriptEngine getEngine(String type) {
        return map.get(type);
    }

    static {
        JavaScriptEngine engine = new JavaScriptEngine();
        map.put("js", engine);
        map.put("javascript", engine);
        map.put("groovy", new GroovyEngine());
        map.put("ruby", new RubyScriptEngine());
        map.put("python", new PythonScriptEngine());
        try {
            map.put("java", new JavaEngine());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Class.forName("org.springframework.expression.ExpressionParser");
            map.put("spel", new SpElEngine());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            Class.forName("ognl.Ognl");
            map.put("ognl", new OgnlEngine());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

