package cc.kebei.expands.office.excel.wrapper;


import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.BeanUtilsBean;
import cc.kebei.utils.ClassUtils;
import cc.kebei.utils.StringUtils;

import java.beans.PropertyDescriptor;
import java.util.Map;

/**
 * Created by 浩 on 2015-12-07 0007.
 */
public class BeanWrapper<T> extends AbstractWrapper<T> {

    private Class<T> type;

    public BeanWrapper() {
    }

    public BeanWrapper(Class<T> type) {
        this.type = type;
    }

    public BeanWrapper(Class<T> type, Map<String, String> headerMapping) {
        this.type = type;
        this.headerNameMapper = headerMapping;
    }

    @Override
    public T newInstance() throws Exception {
        if (type == null) {
            type = (Class<T>) ClassUtils.getGenericType(this.getClass());
        }
        return type.newInstance();
    }

    @Override
    public void wrapper(T instance, String header, Object value) {
        if (header == null || "".equals(header)) return;
        header = header.trim();
        header = headerMapper(header);
        try {
            PropertyDescriptor propertyDescriptor = BeanUtilsBean.getInstance()
                    .getPropertyUtils().getPropertyDescriptor(instance, header);
            if (propertyDescriptor != null) {
                value = changeType(value, propertyDescriptor.getPropertyType());
            }
            BeanUtils.setProperty(instance, header, value);
        } catch (Exception e) {
        }
    }


    protected Object changeType(Object value, Class<?> paramType) {
        if (value.getClass() == paramType) return value;
        if (paramType == int.class || paramType == Integer.class) {
            value = StringUtils.toInt(value);
        }
        if (paramType == double.class || paramType == Double.class) {
            value = StringUtils.toDouble(value);
        }
        if (paramType == float.class || paramType == Float.class) {
            value = (float) StringUtils.toDouble(value);
        }
        return value;
    }

    public void setType(Class<T> type) {
        this.type = type;
    }
}
