/*
 * Decompiled with CFR 0.152.
 */
package cc.jinglupeng.wechat.api;

import cc.jinglupeng.wechat.api.BaseAPI;
import cc.jinglupeng.wechat.bean.Status;
import cc.jinglupeng.wechat.bean.media.MediaId;
import cc.jinglupeng.wechat.bean.message.MessageType;
import cc.jinglupeng.wechat.bean.message.mass.Article;
import cc.jinglupeng.wechat.bean.message.mass.MassStatus;
import cc.jinglupeng.wechat.bean.message.mass.MsgId;
import cc.jinglupeng.wechat.bean.message.send.CustomMessage;
import cc.jinglupeng.wechat.util.WxHttpUtils;
import java.util.List;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;

public class MessageAPI {
    private static Logger logger = Logger.getLogger(MessageAPI.class);
    private static final String SEND_CUSTOM_MESSAGE_URL = "https://api.weixin.qq.com/cgi-bin/message/custom/send?access_token=ACCESS_TOKEN";
    private static final String SEND_MASS_MESSAGE_ALL = "https://api.weixin.qq.com/cgi-bin/message/mass/sendall?access_token=ACCESS_TOKEN";
    private static final String SEND_MASS_MESSAGE = "https://api.weixin.qq.com/cgi-bin/message/mass/send?access_token=ACCESS_TOKEN";
    private static final String UPLOAD_VIDEO = "https://file.api.weixin.qq.com/cgi-bin/media/uploadvideo?access_token=ACCESS_TOKEN";
    private static final String UPLOAD_NEWS = "https://api.weixin.qq.com/cgi-bin/media/uploadnews?access_token=ACCESS_TOKEN";
    private static final String MASS_MESSAGE_PREVIEW = "https://api.weixin.qq.com/cgi-bin/message/mass/preview?access_token=ACCESS_TOKEN";
    private static final String MASS_MESSAGE_QUERY_STATUS = "https://api.weixin.qq.com/cgi-bin/message/mass/get?access_token=ACCESS_TOKEN";
    private static final String MASS_MESSAGE_DELETE = "https://api.weixin.qq.com/cgi-bin/message/mass/delete?access_token=ACCESS_TOKEN";

    public static Status sendCustomMessage(String appId, String message) {
        String token = BaseAPI.getAccessToken(appId);
        if (token == null) {
            logger.error((Object)"\u53d1\u9001\u5ba2\u670d\u6d88\u606f\u5931\u8d25\uff0c\u83b7\u53d6AccessToken\u5931\u8d25!");
            return new Status(-4, "\u83b7\u53d6AccessToken\u5931\u8d25");
        }
        String url = SEND_CUSTOM_MESSAGE_URL.replace("ACCESS_TOKEN", token);
        logger.debug((Object)message);
        return WxHttpUtils.post(url, message, Status.class);
    }

    public static Status sendCustomMessage(String appId, CustomMessage message, String openId) {
        String token = BaseAPI.getAccessToken(appId);
        if (token == null) {
            logger.error((Object)"\u53d1\u9001\u5ba2\u670d\u6d88\u606f\u5931\u8d25\uff0c\u83b7\u53d6AccessToken\u5931\u8d25!");
            return new Status(-4, "\u83b7\u53d6AccessToken\u5931\u8d25");
        }
        String url = SEND_CUSTOM_MESSAGE_URL.replace("ACCESS_TOKEN", token);
        String json = message.toJSON(openId);
        logger.debug((Object)json);
        return WxHttpUtils.post(url, json, Status.class);
    }

    public static MsgId sendMassMessage(String appId, MessageType type, String mediaId) {
        if (type.equals((Object)MessageType.video)) {
            type = MessageType.mpvideo;
        }
        String temp = "media_id";
        if (type.equals((Object)MessageType.text)) {
            temp = "content";
        }
        JSONObject json = new JSONObject();
        JSONObject filter = new JSONObject();
        filter.put((Object)"is_to_all", (Object)true);
        json.put((Object)"filter", (Object)filter);
        json.put((Object)"msgtype", (Object)type.toString());
        JSONObject content = new JSONObject();
        content.put((Object)temp, (Object)mediaId);
        json.put((Object)type.toString(), (Object)content);
        String msg = json.toString();
        String token = BaseAPI.getAccessToken(appId);
        if (token == null) {
            logger.error((Object)"\u9ad8\u7ea7\u7fa4\u53d1\u6d88\u606f\u5931\u8d25\uff0c\u83b7\u53d6AccessToken\u5931\u8d25!");
            return new MsgId(-4, "\u83b7\u53d6AccessToken\u5931\u8d25");
        }
        String url = SEND_MASS_MESSAGE.replace("ACCESS_TOKEN", token);
        logger.debug((Object)json);
        return WxHttpUtils.post(url, msg, MsgId.class);
    }

    public static MsgId sendMassMessage(String appId, MessageType type, String mediaId, List<String> openIds) {
        if (type.equals((Object)MessageType.mpvideo)) {
            type = MessageType.video;
        }
        String temp = "media_id";
        if (type.equals((Object)MessageType.text)) {
            temp = "content";
        }
        JSONObject json = new JSONObject();
        json.put((Object)"touser", openIds);
        json.put((Object)"msgtype", (Object)type.toString());
        JSONObject content = new JSONObject();
        content.put((Object)temp, (Object)mediaId);
        json.put((Object)type.toString(), (Object)content);
        String msg = json.toString();
        String token = BaseAPI.getAccessToken(appId);
        if (token == null) {
            logger.error((Object)"\u6309openId\u5217\u8868\u8fdb\u884c\u9ad8\u7ea7\u7fa4\u53d1\u5931\u8d25\uff0c\u83b7\u53d6AccessToken\u5931\u8d25!");
            return new MsgId(-4, "\u83b7\u53d6AccessToken\u5931\u8d25");
        }
        String url = SEND_MASS_MESSAGE.replace("ACCESS_TOKEN", token);
        logger.debug((Object)json);
        return WxHttpUtils.post(url, msg, MsgId.class);
    }

    public static MsgId sendMassMessage(String appId, MessageType type, String mediaId, String groupId) {
        if (type.equals((Object)MessageType.video)) {
            type = MessageType.mpvideo;
        }
        String temp = "media_id";
        if (type.equals((Object)MessageType.text)) {
            temp = "content";
        }
        JSONObject json = new JSONObject();
        JSONObject filter = new JSONObject();
        filter.put((Object)"is_to_all", (Object)false);
        filter.put((Object)"group_id", (Object)groupId);
        json.put((Object)"filter", (Object)filter);
        json.put((Object)"msgtype", (Object)type.toString());
        JSONObject content = new JSONObject();
        content.put((Object)temp, (Object)mediaId);
        json.put((Object)type.toString(), (Object)content);
        String msg = json.toString();
        String token = BaseAPI.getAccessToken(appId);
        if (token == null) {
            logger.error((Object)"\u6839\u636e\u5206\u7ec4\u8fc7\u6ee4\u8fdb\u884c\u9ad8\u7ea7\u7fa4\u53d1\u5931\u8d25\uff0c\u83b7\u53d6AccessToken\u5931\u8d25!");
            return new MsgId(-4, "\u83b7\u53d6AccessToken\u5931\u8d25");
        }
        String url = SEND_MASS_MESSAGE_ALL.replace("ACCESS_TOKEN", token);
        logger.debug((Object)json);
        return WxHttpUtils.post(url, msg, MsgId.class);
    }

    public static MediaId uploadNews(String appId, List<Article> articles) {
        JSONObject json = new JSONObject();
        json.put((Object)"articles", articles);
        String msg = json.toString();
        String token = BaseAPI.getAccessToken(appId);
        if (token == null) {
            logger.error((Object)"\u4e0a\u4f20\u56fe\u6587\u6d88\u606f\u7d20\u6750\u5931\u8d25\uff0c\u83b7\u53d6AccessToken\u5931\u8d25!");
            return new MediaId(-4, "\u83b7\u53d6AccessToken\u5931\u8d25");
        }
        String url = UPLOAD_NEWS.replace("ACCESS_TOKEN", token);
        logger.debug((Object)json);
        return WxHttpUtils.post(url, msg, MediaId.class);
    }

    public static MediaId uploadVideo(String appId, String mediaId, String title, String description) {
        JSONObject json = new JSONObject();
        json.put((Object)"media_id", (Object)mediaId);
        json.put((Object)"title", (Object)title);
        json.put((Object)"description", (Object)description);
        String msg = json.toString();
        String token = BaseAPI.getAccessToken(appId);
        if (token == null) {
            logger.error((Object)"\u4e0a\u4f20\u89c6\u9891\u5931\u8d25\uff0c\u83b7\u53d6AccessToken\u5931\u8d25!");
            return new MediaId(-4, "\u83b7\u53d6AccessToken\u5931\u8d25");
        }
        String url = UPLOAD_VIDEO.replace("ACCESS_TOKEN", token);
        logger.debug((Object)json);
        return WxHttpUtils.post(url, msg, MediaId.class);
    }

    public static MsgId preview(String appId, MessageType type, String mediaId, String openId) {
        if (type.equals((Object)MessageType.video)) {
            type = MessageType.mpvideo;
        }
        String temp = "media_id";
        if (type.equals((Object)MessageType.text)) {
            temp = "content";
        }
        JSONObject json = new JSONObject();
        json.put((Object)"touser", (Object)openId);
        json.put((Object)"msgtype", (Object)type.toString());
        JSONObject content = new JSONObject();
        content.put((Object)temp, (Object)mediaId);
        json.put((Object)type.toString(), (Object)content);
        String msg = json.toString();
        String token = BaseAPI.getAccessToken(appId);
        if (token == null) {
            logger.error((Object)"\u83b7\u53d6AccessToken\u5931\u8d25!");
            return new MsgId(-1, "\u83b7\u53d6AccessToken\u5931\u8d25");
        }
        String url = MASS_MESSAGE_PREVIEW.replace("ACCESS_TOKEN", token);
        logger.debug((Object)json);
        return WxHttpUtils.post(url, msg, MsgId.class);
    }

    public static Status delete(String appId, String msgId) {
        JSONObject json = new JSONObject();
        json.put((Object)"msg_id", (Object)msgId);
        String msg = json.toString();
        String token = BaseAPI.getAccessToken(appId);
        if (token == null) {
            logger.error((Object)"\u5220\u9664\u7fa4\u53d1\u5931\u8d25\uff0c\u83b7\u53d6AccessToken\u5931\u8d25!");
            return new MediaId(-4, "\u83b7\u53d6AccessToken\u5931\u8d25");
        }
        String url = MASS_MESSAGE_DELETE.replace("ACCESS_TOKEN", token);
        logger.debug((Object)json);
        return WxHttpUtils.post(url, msg, Status.class);
    }

    public static MassStatus queryStatus(String appId, String msgId) {
        JSONObject json = new JSONObject();
        json.put((Object)"msg_id", (Object)msgId);
        String msg = json.toString();
        String token = BaseAPI.getAccessToken(appId);
        if (token == null) {
            logger.error((Object)"\u67e5\u8be2\u7fa4\u53d1\u6d88\u606f\u53d1\u9001\u72b6\u6001\u5931\u8d25\uff0c\u83b7\u53d6AccessToken\u5931\u8d25!");
            return new MassStatus(-4, "\u83b7\u53d6AccessToken\u5931\u8d25");
        }
        String url = MASS_MESSAGE_QUERY_STATUS.replace("ACCESS_TOKEN", token);
        logger.debug((Object)json);
        return WxHttpUtils.post(url, msg, MassStatus.class);
    }
}

