/*
 * Decompiled with CFR 0.152.
 */
package cc.jinglupeng.wechat;

import cc.jinglupeng.wechat.WechatCache;
import cc.jinglupeng.wechat.bean.AccessToken;
import cc.jinglupeng.wechat.bean.JSAPITicket;
import java.util.HashMap;
import java.util.Map;

public class DefaultWechatCache
implements WechatCache {
    private static final Map<String, JSAPITicket> JSAPITICKET_CACHE = new HashMap<String, JSAPITicket>();
    private static final Map<String, AccessToken> ACCESSTOKEN_CACHE = new HashMap<String, AccessToken>();

    @Override
    public AccessToken getAccessToken(String appId) {
        AccessToken token = ACCESSTOKEN_CACHE.get(appId);
        if (token == null) {
            return null;
        }
        Long now = System.currentTimeMillis();
        Long old = token.getCreateTime();
        if (now - old > 6000000L) {
            return null;
        }
        return token;
    }

    @Override
    public void cacheAccessToken(String appId, AccessToken accessToken) {
        ACCESSTOKEN_CACHE.put(appId, accessToken);
    }

    @Override
    public JSAPITicket getJSAPITicket(String appId) {
        JSAPITicket ticket = JSAPITICKET_CACHE.get(appId);
        if (ticket == null) {
            return null;
        }
        Long now = System.currentTimeMillis();
        Long old = ticket.getCreateTime();
        if (now - old > 6000000L) {
            return null;
        }
        return ticket;
    }

    @Override
    public void cacheJSAPITicket(String appId, JSAPITicket ticket) {
        JSAPITICKET_CACHE.put(appId, ticket);
    }
}

