/*
 * Decompiled with CFR 0.152.
 */
package cc.jinglupeng.wechat.util;

import cc.jinglupeng.wechat.bean.Status;
import cc.jinglupeng.wechat.bean.media.Media;
import cc.jinglupeng.wechat.util.JSONUtil;
import cc.jinglupeng.wechat.util.MapUtil;
import cc.jinglupeng.wechat.util.MyX509TrustManager;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class WxHttpUtils {
    private static final Logger logger = Logger.getLogger(WxHttpUtils.class);
    private static final String CHARSET = "UTF-8";
    private static SSLSocketFactory sslSocketFactory = null;
    private static int timeout = 30000;

    public static final <T extends Status> T get(String url, Map<String, String> params, Class<T> t) {
        StringBuilder sb = new StringBuilder(url);
        if (url.indexOf("?") == -1) {
            sb.append("?");
        } else {
            sb.append("&");
        }
        sb.append(MapUtil.join(params));
        url = sb.toString();
        return WxHttpUtils.get(url, t);
    }

    public static final <T extends Status> T get(String url, Class<T> t) {
        try {
            String json = WxHttpUtils.get(url);
            Status result = (Status)JSONUtil.parse(json, t);
            return (T)result;
        }
        catch (Exception e) {
            logger.error((Object)"GET \u8bf7\u6c42\u5931\u8d25");
            logger.error((Object)("URL:" + url));
            logger.error((Object)e);
            Status result = null;
            try {
                result = (Status)t.newInstance();
            }
            catch (Exception e1) {
                // empty catch block
            }
            result.setErrcode(-2);
            result.setErrmsg("\u7f51\u7edc\u9519\u8bef\uff01");
            return (T)result;
        }
    }

    public static final <T extends Status> T post(String url, Map<String, String> params, Class<T> t) {
        String data = MapUtil.join(params);
        return WxHttpUtils.post(url, data, t);
    }

    public static final <T extends Status> T post(String url, String data, Class<T> t) {
        try {
            String json = WxHttpUtils.post(url, data);
            Status result = (Status)JSONUtil.parse(json, t);
            return (T)result;
        }
        catch (Exception e) {
            logger.error((Object)"POST \u8bf7\u6c42\u5931\u8d25");
            logger.error((Object)("URL:" + url));
            logger.error((Object)("DATA:" + data));
            logger.error((Object)e);
            Status result = null;
            try {
                result = (Status)t.newInstance();
            }
            catch (Exception e1) {
                // empty catch block
            }
            result.setErrcode(-2);
            result.setErrmsg("\u7f51\u7edc\u9519\u8bef\uff01");
            return (T)result;
        }
    }

    public static final <T extends Status> T uploadMedia(String url, File file, Class<T> t) {
        try {
            String json = WxHttpUtils.upload(url, file);
            Status result = (Status)JSONUtil.parse(json, t);
            return (T)result;
        }
        catch (Exception e) {
            logger.error((Object)"Upload \u8bf7\u6c42\u5931\u8d25");
            logger.error((Object)("URL:" + url));
            logger.error((Object)("File:" + file.getAbsolutePath()));
            logger.error((Object)e);
            Status result = null;
            try {
                result = (Status)t.newInstance();
            }
            catch (Exception e1) {
                // empty catch block
            }
            result.setErrcode(-2);
            result.setErrmsg("\u7f51\u7edc\u9519\u8bef\uff01");
            return (T)result;
        }
    }

    public static String get(String url) throws IOException {
        logger.info((Object)("GET:" + url));
        StringBuffer bufferRes = null;
        URL urlGet = new URL(url);
        HttpURLConnection http = (HttpURLConnection)urlGet.openConnection();
        if (http instanceof HttpsURLConnection) {
            ((HttpsURLConnection)http).setSSLSocketFactory(sslSocketFactory);
        }
        http.setConnectTimeout(timeout);
        http.setReadTimeout(timeout);
        http.setRequestMethod("GET");
        http.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        http.setDoOutput(true);
        http.setDoInput(true);
        http.connect();
        InputStream in = http.getInputStream();
        BufferedReader read = new BufferedReader(new InputStreamReader(in, CHARSET));
        String valueString = null;
        bufferRes = new StringBuffer();
        while ((valueString = read.readLine()) != null) {
            bufferRes.append(valueString);
        }
        in.close();
        if (http != null) {
            http.disconnect();
        }
        logger.info((Object)bufferRes.toString());
        return bufferRes.toString();
    }

    public static String get(String url, Map<String, String> params) throws KeyManagementException, NoSuchAlgorithmException, NoSuchProviderException, IOException {
        return WxHttpUtils.get(WxHttpUtils.initParams(url, params));
    }

    public static String post(String url) throws IOException {
        return WxHttpUtils.post(url, null);
    }

    public static String post(String url, String data) throws IOException {
        logger.info((Object)("POST:" + url));
        StringBuffer bufferRes = null;
        URL urlGet = new URL(url);
        HttpURLConnection http = (HttpURLConnection)urlGet.openConnection();
        if (http instanceof HttpsURLConnection) {
            ((HttpsURLConnection)http).setSSLSocketFactory(sslSocketFactory);
        }
        http.setConnectTimeout(timeout);
        http.setReadTimeout(timeout);
        http.setRequestMethod("POST");
        http.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        http.setDoOutput(true);
        http.setDoInput(true);
        http.connect();
        if (data != null && data.length() > 0) {
            OutputStream out = http.getOutputStream();
            out.write(data.getBytes(CHARSET));
            out.flush();
            out.close();
        }
        InputStream in = http.getInputStream();
        BufferedReader read = new BufferedReader(new InputStreamReader(in, CHARSET));
        String valueString = null;
        bufferRes = new StringBuffer();
        while ((valueString = read.readLine()) != null) {
            bufferRes.append(valueString);
        }
        in.close();
        if (http != null) {
            http.disconnect();
        }
        logger.info((Object)bufferRes.toString());
        return bufferRes.toString();
    }

    public static String upload(String url, File file) throws IOException, NoSuchAlgorithmException, NoSuchProviderException, KeyManagementException {
        String BOUNDARY = "----WebKitFormBoundaryiDGnV9zdZA1eM1yL";
        StringBuffer bufferRes = null;
        URL urlGet = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)urlGet.openConnection();
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setUseCaches(false);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("connection", "Keep-Alive");
        conn.setRequestProperty("user-agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/32.0.1700.107 Safari/537.36");
        conn.setRequestProperty("Charsert", CHARSET);
        conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + BOUNDARY);
        DataOutputStream out = new DataOutputStream(conn.getOutputStream());
        byte[] end_data = ("\r\n--" + BOUNDARY + "--\r\n").getBytes();
        StringBuilder sb = new StringBuilder();
        sb.append("--");
        sb.append(BOUNDARY);
        sb.append("\r\n");
        sb.append("Content-Disposition: form-data;name=\"media\";filename=\"" + file.getName() + "\"\r\n");
        sb.append("Content-Type:application/octet-stream\r\n\r\n");
        byte[] data = sb.toString().getBytes();
        ((OutputStream)out).write(data);
        DataInputStream fs = new DataInputStream(new FileInputStream(file));
        int bytes = 0;
        byte[] bufferOut = new byte[1024];
        while ((bytes = fs.read(bufferOut)) != -1) {
            ((OutputStream)out).write(bufferOut, 0, bytes);
        }
        ((OutputStream)out).write("\r\n".getBytes());
        fs.close();
        ((OutputStream)out).write(end_data);
        ((OutputStream)out).flush();
        ((OutputStream)out).close();
        InputStream in = conn.getInputStream();
        BufferedReader read = new BufferedReader(new InputStreamReader(in, CHARSET));
        String valueString = null;
        bufferRes = new StringBuffer();
        while ((valueString = read.readLine()) != null) {
            bufferRes.append(valueString);
        }
        in.close();
        if (conn != null) {
            conn.disconnect();
        }
        return bufferRes.toString();
    }

    public static Media downloadMedia(String url) throws IOException {
        logger.info((Object)("Download:" + url));
        Media media = null;
        URL urlGet = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)urlGet.openConnection();
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setUseCaches(false);
        conn.setRequestMethod("GET");
        conn.connect();
        if (conn.getContentType().equalsIgnoreCase("text/plain")) {
            InputStream in = conn.getInputStream();
            String json = IOUtils.toString((InputStream)in);
            in.close();
            media = JSONUtil.parse(json, Media.class);
        } else {
            BufferedInputStream bis = new BufferedInputStream(conn.getInputStream());
            String ds = conn.getHeaderField("Content-disposition");
            String fullName = ds.substring(ds.indexOf("filename=\"") + 10, ds.length() - 1);
            String relName = fullName.substring(0, fullName.lastIndexOf("."));
            String suffix = fullName.substring(relName.length() + 1);
            media = new Media(0, "");
            media.setFullName(fullName);
            media.setFileName(relName);
            media.setSuffix(suffix);
            media.setContentLength(conn.getHeaderField("Content-Length"));
            media.setContentType(conn.getHeaderField("Content-Type"));
            media.setFileStream(bis);
        }
        if (media == null) {
            media = new Media(-2, "\u7f51\u7edc\u9519\u8bef\uff01");
        }
        return media;
    }

    private static String initParams(String url, Map<String, String> params) {
        if (null == params || params.isEmpty()) {
            return url;
        }
        StringBuilder sb = new StringBuilder(url);
        if (url.indexOf("?") == -1) {
            sb.append("?");
        } else {
            sb.append("&");
        }
        boolean first = true;
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append("&");
            }
            String key = entry.getKey();
            String value = entry.getValue();
            sb.append(key).append("=");
            if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
            try {
                sb.append(URLEncoder.encode(value, CHARSET));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                logger.error((Object)url, (Throwable)e);
            }
        }
        return sb.toString();
    }

    static {
        TrustManager[] trustManagers = new TrustManager[]{new MyX509TrustManager()};
        KeyManager[] keyManagers = null;
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL", "SunJSSE");
            sslContext.init(keyManagers, trustManagers, new SecureRandom());
            sslSocketFactory = sslContext.getSocketFactory();
        }
        catch (Exception e) {
            logger.error((Object)"\u521b\u5efa SSLSocketFactory \u5931\u8d25\uff01");
            logger.error((Object)e);
        }
    }
}

