/*
 * Decompiled with CFR 0.152.
 */
package cc.jinglupeng.wechat.api;

import cc.jinglupeng.wechat.api.BaseAPI;
import cc.jinglupeng.wechat.bean.oauth.OAuthAccessToken;
import cc.jinglupeng.wechat.bean.oauth.OAuthUser;
import cc.jinglupeng.wechat.util.WxHttpUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.log4j.Logger;

public class OAuth2API {
    private static Logger logger = Logger.getLogger(OAuth2API.class);
    private static final String OAUTH2URL = "https://open.weixin.qq.com/connect/oauth2/authorize";
    private static final String OAUTH2_GET_ACCESSTOKEN = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=APPID&secret=APPSECRET&code=CODE&grant_type=authorization_code";
    private static final String OAUTH2_REFRESH_TOKEN = "https://api.weixin.qq.com/sns/oauth2/refresh_token?appid=APPID&grant_type=refresh_token&refresh_token=REFRESH_TOKEN";
    private static final String OAUTH2_GET_USERINFO = "https://api.weixin.qq.com/sns/userinfo?access_token=ACCESS_TOKEN&openid=OPENID&lang=zh_CN";

    public static String generateOAuth2BaseUrl(String appId, String uri) {
        try {
            uri = URLEncoder.encode(uri, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)e.getMessage());
            return null;
        }
        StringBuilder sb = new StringBuilder(OAUTH2URL);
        sb.append("?appid=" + appId);
        sb.append("&redirect_uri=" + uri);
        sb.append("&response_type=code");
        sb.append("&scope=snsapi_base");
        sb.append("&state=0");
        sb.append("#wechat_redirect");
        return sb.toString();
    }

    public static String generateOAuth2UserInfoUrl(String appId, String uri) {
        try {
            uri = URLEncoder.encode(uri, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)e.getMessage());
            return null;
        }
        StringBuilder sb = new StringBuilder(OAUTH2URL);
        sb.append("?appid=" + appId);
        sb.append("&redirect_uri=" + uri);
        sb.append("&response_type=code");
        sb.append("&scope=snsapi_userinfo");
        sb.append("&state=0");
        sb.append("#wechat_redirect");
        return sb.toString();
    }

    public static OAuthAccessToken getAccessToken(String appId, String code) {
        String appSecret = BaseAPI.getAppSecret(appId);
        if (appSecret == null) {
            logger.error((Object)("\u901a\u8fc7code\u6362\u53d6\u7f51\u9875\u6388\u6743access_token\u5931\u8d25,\u83b7\u53d6Appsecret\u5931\u8d25\uff0cAppId:" + appId));
            return new OAuthAccessToken(-6, "\u83b7\u53d6Appsecret\u5931\u8d25\uff01");
        }
        String url = OAUTH2_GET_ACCESSTOKEN.replaceAll("APPID", appId).replaceAll("APPSECRET", appSecret).replaceAll("CODE", code);
        try {
            return WxHttpUtils.get(url, OAuthAccessToken.class);
        }
        catch (Exception e) {
            logger.error((Object)("\u83b7\u53d6\u7f51\u9875\u6388\u6743access_token\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f:" + e.getMessage()));
            return new OAuthAccessToken(-5, "\u672a\u77e5\u9519\u8bef\uff01");
        }
    }

    public static OAuthAccessToken refreshAccessToken(String appId, String refreshToken) {
        String appSecret = BaseAPI.getAppSecret(appId);
        if (appSecret == null) {
            logger.error((Object)("\u5237\u65b0\u7f51\u9875\u6388\u6743access_token,\u83b7\u53d6Appsecret\u5931\u8d25\uff0cAppId:" + appId));
            return new OAuthAccessToken(-6, "\u83b7\u53d6Appsecret\u5931\u8d25\uff01");
        }
        String url = OAUTH2_REFRESH_TOKEN.replaceAll("APPID", appId).replaceAll("REFRESH_TOKEN", refreshToken);
        try {
            return WxHttpUtils.get(url, OAuthAccessToken.class);
        }
        catch (Exception e) {
            logger.error((Object)("\u5237\u65b0\u7f51\u9875\u6388\u6743access_token\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f:" + e.getMessage()));
            return new OAuthAccessToken(-5, "\u672a\u77e5\u9519\u8bef\uff01");
        }
    }

    public static OAuthUser getUserInfo(String accessToken, String openId) {
        String url = OAUTH2_GET_USERINFO.replaceAll("ACCESS_TOKEN", accessToken).replaceAll("OPENID", openId);
        try {
            return WxHttpUtils.get(url, OAuthUser.class);
        }
        catch (Exception e) {
            logger.error((Object)("\u901a\u8fc7\u7f51\u9875\u6388\u6743AccessToken\u62c9\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f:" + e.getMessage()));
            return new OAuthUser(-5, "\u672a\u77e5\u9519\u8bef\uff01");
        }
    }
}

