/*
 * Decompiled with CFR 0.152.
 */
package cc.jinglupeng.wechat.api;

import cc.jinglupeng.wechat.api.BaseAPI;
import cc.jinglupeng.wechat.bean.Status;
import cc.jinglupeng.wechat.bean.menu.Menu;
import cc.jinglupeng.wechat.bean.menu.MenuResp;
import cc.jinglupeng.wechat.util.WxHttpUtils;
import org.apache.log4j.Logger;

public final class MenuAPI {
    private static Logger logger = Logger.getLogger(MenuAPI.class);
    private static final String GET_MENU_URL = "https://api.weixin.qq.com/cgi-bin/menu/get?access_token=ACCESS_TOKEN";
    private static final String DELETE_MENU_URL = "https://api.weixin.qq.com/cgi-bin/menu/delete?access_token=ACCESS_TOKEN";
    private static final String CREATE_MENU_URL = " https://api.weixin.qq.com/cgi-bin/menu/create?access_token=ACCESS_TOKEN";

    public static Menu getMenu(String appId) {
        String token = BaseAPI.getAccessToken(appId);
        if (token == null) {
            logger.error((Object)"\u81ea\u5b9a\u4e49\u83dc\u5355\u67e5\u8be2\u5931\u8d25, \u83b7\u53d6AccessToken\u5931\u8d25!");
            return null;
        }
        String url = GET_MENU_URL.replace("ACCESS_TOKEN", token);
        MenuResp menu = WxHttpUtils.get(url, MenuResp.class);
        if (menu.isSuccess()) {
            return menu.getMenu();
        }
        return null;
    }

    public static Boolean deleteMenu(String appId) {
        String token = BaseAPI.getAccessToken(appId);
        if (token == null) {
            logger.error((Object)"\u5220\u9664\u83dc\u5355\u5931\u8d25, \u83b7\u53d6AccessToken\u5931\u8d25!");
            return false;
        }
        String url = DELETE_MENU_URL.replace("ACCESS_TOKEN", token);
        Status status = WxHttpUtils.get(url, Status.class);
        return status.isSuccess();
    }

    public static Boolean createMenu(String appId, String menu) {
        String token = BaseAPI.getAccessToken(appId);
        if (token == null) {
            logger.error((Object)"\u81ea\u5b9a\u4e49\u83dc\u5355\u521b\u5efa\u5931\u8d25\uff0c\u83b7\u53d6AccessToken\u5931\u8d25!");
            return false;
        }
        String url = CREATE_MENU_URL.replace("ACCESS_TOKEN", token);
        Status status = WxHttpUtils.post(url, menu, Status.class);
        return status.isSuccess();
    }
}

