/*
 * Decompiled with CFR 0.152.
 */
package cc.jinglupeng.wechat.api;

import cc.jinglupeng.wechat.JSAPITicketCache;
import cc.jinglupeng.wechat.api.BaseAPI;
import cc.jinglupeng.wechat.bean.JSAPITicket;
import cc.jinglupeng.wechat.util.SignUtils;
import cc.jinglupeng.wechat.util.WxHttpUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;

public class JSAPI {
    private static Logger logger = Logger.getLogger(JSAPI.class);
    private static String GET_TICKET_URL = "https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token=ACCESS_TOKEN&type=jsapi";

    public static JSAPITicket getJSAPITicketFromServer(String appId) {
        String token = BaseAPI.getAccessToken(appId);
        if (token == null) {
            logger.error((Object)"\u83b7\u53d6JSAPI Ticket\u5931\u8d25\uff0c\u83b7\u53d6AccessToken\u5931\u8d25!");
            return new JSAPITicket(-4, "\u83b7\u53d6AccessToken\u5931\u8d25");
        }
        String url = GET_TICKET_URL.replace("ACCESS_TOKEN", token);
        try {
            JSAPITicket ticket = WxHttpUtils.get(url, JSAPITicket.class);
            if (ticket.isSuccess()) {
                ticket.setCreateTime(System.currentTimeMillis());
                JSAPITicketCache.put(appId, ticket);
                return ticket;
            }
            logger.error((Object)("\u83b7\u53d6JSAPITicket\u5931\u8d25\uff0cAppId:" + appId + ",\u9519\u8bef\u7801\uff1a" + ticket.getErrcode()));
            return new JSAPITicket(-2, "\u83b7\u53d6JSAPITicket\u5931\u8d25");
        }
        catch (Exception e) {
            logger.error((Object)("\u83b7\u53d6JSAPI Ticket\u5931\u8d25, \u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage()));
            return new JSAPITicket(-5, "\u672a\u77e5\u9519\u8bef\uff01");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getJSAPITicket(String appId) {
        JSAPITicket ticket = JSAPITicketCache.get(appId);
        if (ticket == null) {
            Class<JSAPI> clazz = JSAPI.class;
            synchronized (JSAPI.class) {
                ticket = JSAPITicketCache.get(appId);
                if (ticket != null) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return ticket.getTicket();
                }
                ticket = JSAPI.getJSAPITicketFromServer(appId);
                if (!ticket.isSuccess()) {
                    logger.error((Object)("\u4ece\u5fae\u4fe1\u670d\u52a1\u5668\u83b7\u53d6JSAPITicket\u5931\u8d25\uff0cAppId:" + appId));
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return null;
                }
                logger.debug((Object)("Ticket:" + ticket.getTicket()));
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return ticket.getTicket();
            }
        }
        return ticket.getTicket();
    }

    public static Map<String, String> getJSAPIConfig(String appId, String url) {
        String jsapi_ticket = JSAPI.getJSAPITicket(appId);
        if (jsapi_ticket == null) {
            logger.error((Object)"JSAPI\u7b7e\u540d\u5931\u8d25\uff0c\u83b7\u53d6JSAPITicket\u5931\u8d25");
            return null;
        }
        String timeStamp = Long.toString(System.currentTimeMillis() / 1000L);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("jsapi_ticket", jsapi_ticket);
        params.put("nonceStr", UUID.randomUUID().toString());
        params.put("timestamp", timeStamp);
        params.put("url", url);
        String signature = SignUtils.sha1Sign(params);
        params.put("signature", signature);
        params.put("appId", appId);
        params.remove("jsapi_ticket");
        params.remove("url");
        return params;
    }
}

