/*
 * Decompiled with CFR 0.152.
 */
package cc.jinglupeng.wechat.api;

import cc.jinglupeng.wechat.api.BaseAPI;
import cc.jinglupeng.wechat.bean.group.Group;
import cc.jinglupeng.wechat.util.WxHttpUtils;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;

public class GroupAPI {
    private static Logger logger = Logger.getLogger(GroupAPI.class);
    private static final String CREATE_GROUP_URL = "https://api.weixin.qq.com/cgi-bin/groups/create?access_token=ACCESS_TOKEN";
    private static final String GET_GROUPS_URL = "https://api.weixin.qq.com/cgi-bin/groups/get?access_token=ACCESS_TOKEN";
    private static final String GET_USER_GROUP_ID_URL = "https://api.weixin.qq.com/cgi-bin/groups/getid?access_token=ACCESS_TOKEN";
    private static final String UPDATE_GROUP_URL = "https://api.weixin.qq.com/cgi-bin/groups/update?access_token=ACCESS_TOKEN";
    private static final String MOVE_MEMBER_GROUP_URL = "https://api.weixin.qq.com/cgi-bin/groups/members/update?access_token=ACCESS_TOKEN";

    public static Group createGroup(String appId, String name) {
        if (name == null || name.length() <= 0 || name.length() >= 30) {
            logger.error((Object)("\u521b\u5efa\u5206\u7ec4\u5931\u8d25\uff0c\u5206\u7ec4\u540d\u79f0\u5fc5\u987b\u572830\u4e2a\u5b57\u7b26\u4ee5\u5185, \u5206\u7ec4\u540d\u79f0:" + name));
            return null;
        }
        JSONObject json1 = new JSONObject();
        JSONObject json2 = new JSONObject();
        json2.put((Object)"name", (Object)name);
        json1.put((Object)"group", (Object)json2);
        String json = json1.toString();
        logger.info((Object)json);
        String token = BaseAPI.getAccessToken(appId);
        if (token == null) {
            logger.error((Object)"\u521b\u5efa\u5206\u7ec4\u5931\u8d25, \u83b7\u53d6AccessToken\u5931\u8d25!");
            return null;
        }
        String url = CREATE_GROUP_URL.replace("ACCESS_TOKEN", token);
        try {
            int errcode;
            json = WxHttpUtils.post(url, json);
            JSONObject jsonObject = JSONObject.fromObject((Object)json);
            if (jsonObject.containsKey((Object)"errcode") && (errcode = jsonObject.getInt("errcode")) != 0) {
                logger.error((Object)("\u521b\u5efa\u5206\u7ec4\u5931\u8d25\uff0c\u9519\u8bef\u7801\uff1a" + errcode));
                return null;
            }
            jsonObject = jsonObject.getJSONObject("group");
            String id = jsonObject.getString("id");
            name = jsonObject.getString("name");
            Group group = new Group();
            group.setCount(0L);
            group.setId(id);
            group.setName(name);
            return group;
        }
        catch (Exception e) {
            logger.error((Object)("\u521b\u5efa\u5206\u7ec4\u5931\u8d25, \u9519\u8bef\u4fe1\u606f:" + e.getMessage()));
            return null;
        }
    }

    public static List<Group> getGroups(String appId) {
        String token = BaseAPI.getAccessToken(appId);
        if (token == null) {
            logger.error((Object)"\u521b\u5efa\u5206\u7ec4\u5931\u8d25, \u83b7\u53d6AccessToken\u5931\u8d25!");
            return null;
        }
        String url = GET_GROUPS_URL.replace("ACCESS_TOKEN", token);
        try {
            int errcode;
            String json = WxHttpUtils.get(url);
            JSONObject jsonObject = JSONObject.fromObject((Object)json);
            if (jsonObject.containsKey((Object)"errcode") && (errcode = jsonObject.getInt("errcode")) != 0) {
                logger.error((Object)("\u67e5\u8be2\u5206\u7ec4\u5217\u8868\u5931\u8d25\uff0c\u9519\u8bef\u7801\uff1a" + errcode));
                return null;
            }
            JSONArray jsonArray = jsonObject.getJSONArray("groups");
            ArrayList<Group> groups = new ArrayList<Group>();
            int length = jsonArray.size();
            for (int i = 0; i < length; ++i) {
                jsonObject = jsonArray.getJSONObject(i);
                Group group = new Group();
                group.setCount(jsonObject.getLong("count"));
                group.setId(jsonObject.getString("id"));
                group.setName(jsonObject.getString("name"));
                groups.add(group);
            }
            return groups;
        }
        catch (Exception e) {
            logger.error((Object)("\u67e5\u8be2\u6240\u6709\u5206\u7ec4\u5931\u8d25, \u9519\u8bef\u4fe1\u606f:" + e.getMessage()));
            return null;
        }
    }

    public static String getUserGroupId(String appId, String openId) {
        String token = BaseAPI.getAccessToken(appId);
        if (token == null) {
            logger.error((Object)"\u521b\u5efa\u5206\u7ec4\u5931\u8d25, \u83b7\u53d6AccessToken\u5931\u8d25!");
            return null;
        }
        String url = GET_USER_GROUP_ID_URL.replace("ACCESS_TOKEN", token);
        try {
            int errcode;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"openid", (Object)openId);
            String json = jsonObject.toString();
            json = WxHttpUtils.post(url, json);
            jsonObject = JSONObject.fromObject((Object)json);
            if (jsonObject.containsKey((Object)"errcode") && (errcode = jsonObject.getInt("errcode")) != 0) {
                logger.error((Object)("\u67e5\u8be2\u7528\u6237\u6240\u5728\u5206\u7ec4\u5931\u8d25\uff0c\u9519\u8bef\u7801\uff1a" + errcode));
                return null;
            }
            return jsonObject.getString("groupid");
        }
        catch (Exception e) {
            logger.error((Object)("\u67e5\u8be2\u7528\u6237\u6240\u5728\u5206\u7ec4\u5931\u8d25, \u9519\u8bef\u4fe1\u606f:" + e.getMessage()));
            return null;
        }
    }

    public static boolean updateGroup(String appId, Group group) {
        String token = BaseAPI.getAccessToken(appId);
        if (token == null) {
            logger.error((Object)"\u521b\u5efa\u5206\u7ec4\u5931\u8d25, \u83b7\u53d6AccessToken\u5931\u8d25!");
            return false;
        }
        String url = UPDATE_GROUP_URL.replace("ACCESS_TOKEN", token);
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"group", (Object)group);
            String json = jsonObject.toString();
            json = WxHttpUtils.post(url, json);
            jsonObject = JSONObject.fromObject((Object)json);
            int errcode = jsonObject.getInt("errcode");
            if (errcode == 0) {
                return true;
            }
            logger.error((Object)("\u4fee\u6539\u5206\u7ec4\u540d\u79f0\u5931\u8d25\uff0c\u9519\u8bef\u7801\uff1a" + errcode));
            return false;
        }
        catch (Exception e) {
            logger.error((Object)("\u4fee\u6539\u5206\u7ec4\u540d\u79f0\u5931\u8d25, \u9519\u8bef\u4fe1\u606f:" + e.getMessage()));
            return false;
        }
    }

    public static boolean moveMemberGroup(String appId, String openId, String groupId) {
        String token = BaseAPI.getAccessToken(appId);
        if (token == null) {
            logger.error((Object)"\u79fb\u52a8\u7528\u6237\u5206\u7ec4\u5931\u8d25, \u83b7\u53d6AccessToken\u5931\u8d25!");
            return false;
        }
        String url = MOVE_MEMBER_GROUP_URL.replace("ACCESS_TOKEN", token);
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"openid", (Object)openId);
            jsonObject.put((Object)"to_groupid", (Object)groupId);
            String json = jsonObject.toString();
            json = WxHttpUtils.post(url, json);
            jsonObject = JSONObject.fromObject((Object)json);
            int errcode = jsonObject.getInt("errcode");
            if (errcode == 0) {
                return true;
            }
            logger.error((Object)("\u79fb\u52a8\u7528\u6237\u5206\u7ec4\u5931\u8d25\uff0c\u9519\u8bef\u7801\uff1a" + errcode));
            return false;
        }
        catch (Exception e) {
            logger.error((Object)("\u79fb\u52a8\u7528\u6237\u5206\u7ec4\u5931\u8d25, \u9519\u8bef\u4fe1\u606f:" + e.getMessage()));
            return false;
        }
    }
}

