/*
 * Decompiled with CFR 0.152.
 */
package cc.jinglupeng.wechat.api;

import cc.jinglupeng.wechat.AccessTokenCache;
import cc.jinglupeng.wechat.AccountCache;
import cc.jinglupeng.wechat.bean.AccessToken;
import cc.jinglupeng.wechat.bean.Account;
import cc.jinglupeng.wechat.bean.media.Media;
import cc.jinglupeng.wechat.bean.media.MediaId;
import cc.jinglupeng.wechat.consts.MediaType;
import cc.jinglupeng.wechat.util.WxHttpUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.log4j.Logger;

public class BaseAPI {
    private static Logger logger = Logger.getLogger(BaseAPI.class);
    private static final String UPLOAD_MEDIA_URL = "http://file.api.weixin.qq.com/cgi-bin/media/upload?access_token=ACCESS_TOKEN&type=TYPE";
    private static final String DOWN_MEDIA_URL = "http://file.api.weixin.qq.com/cgi-bin/media/get?access_token=ACCESS_TOKEN&media_id=MEDIA_ID";
    public static String ACCESS_TOKEN_URL = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=APPID&secret=APPSECRET";

    public static AccessToken getAccessTokenFromServer(String appId, String appSecret) {
        String url = ACCESS_TOKEN_URL.replaceAll("APPID", appId).replaceAll("APPSECRET", appSecret);
        AccessToken token = WxHttpUtils.get(url, AccessToken.class);
        if (token.isSuccess()) {
            token.setCreateTime(System.currentTimeMillis());
            AccessTokenCache.put(appId, token);
            return token;
        }
        logger.error((Object)("\u83b7\u53d6AccessToken\u5931\u8d25\uff0cAppId:" + appId + ",\u9519\u8bef\u7801\uff1a" + token.getErrcode()));
        return new AccessToken(-2, "\u83b7\u53d6AccessToken\u5931\u8d25");
    }

    protected static synchronized String getAppSecret(String appId) {
        Account account = AccountCache.get(appId);
        if (account == null) {
            logger.error((Object)("\u672a\u627e\u5230appId[" + appId + "]\u7684\u4fe1\u606f\uff01"));
            return null;
        }
        return account.getAppSecret();
    }

    public static synchronized String getAccessToken(String appId) {
        AccessToken cacheToken = AccessTokenCache.get(appId);
        if (cacheToken != null) {
            return cacheToken.getAccess_token();
        }
        String appSecret = BaseAPI.getAppSecret(appId);
        if (appSecret == null) {
            logger.error((Object)("\u83b7\u53d6Appsecret\u5931\u8d25\uff0cAppId:" + appId));
            return null;
        }
        AccessToken accessToken = BaseAPI.getAccessTokenFromServer(appId, appSecret);
        if (!accessToken.isSuccess()) {
            logger.error((Object)("\u4ece\u5fae\u4fe1\u670d\u52a1\u5668\u83b7\u53d6Appsecret\u5931\u8d25\uff0cAppId:" + appId));
            return null;
        }
        logger.debug((Object)("Token:" + accessToken.getAccess_token()));
        return accessToken.getAccess_token();
    }

    public static MediaId uploadMedia(String appId, File file, MediaType type) {
        if (!type.checkSizeLimit(file)) {
            logger.error((Object)("\u4e0a\u4f20\u591a\u5a92\u4f53\u6587\u4ef6\u5931\u8d25\uff0c\u6587\u4ef6\u5927\u5c0f\u8d85\u8fc7\u9650\u5236\u3002\u9650\u5236\u4e3a\uff1a " + type.getLimitSize() + "\u3002\u6587\u4ef6\u5730\u5740\uff1a" + file.getAbsolutePath()));
            return new MediaId(-3, "\u4e0a\u4f20\u6587\u4ef6\u5927\u5c0f\u8d85\u8fc7\u9650\u5236\uff01");
        }
        String token = BaseAPI.getAccessToken(appId);
        if (token == null) {
            logger.error((Object)"\u4e0a\u4f20\u591a\u5a92\u4f53\u6587\u4ef6\u5931\u8d25\uff0c\u83b7\u53d6AccessToken\u5931\u8d25\uff01");
            return new MediaId(-4, "\u83b7\u53d6AccessToken\u5931\u8d25\uff01");
        }
        String url = UPLOAD_MEDIA_URL.replace("ACCESS_TOKEN", token).replace("TYPE", (Object)((Object)type) + "");
        return WxHttpUtils.uploadMedia(url, file, MediaId.class);
    }

    public static Media downMedia(String appId, String mediaId) {
        String token = BaseAPI.getAccessToken(appId);
        if (token == null) {
            logger.error((Object)"\u4e0b\u8f7d\u591a\u5a92\u4f53\u6587\u4ef6\u5931\u8d25\uff0c\u83b7\u53d6AccessToken\u5931\u8d25\uff01");
            return new Media(-4, "\u83b7\u53d6AccessToken\u5931\u8d25\uff01");
        }
        String url = DOWN_MEDIA_URL.replace("ACCESS_TOKEN", token).replace("MEDIA_ID", mediaId);
        try {
            return WxHttpUtils.downloadMedia(url);
        }
        catch (IOException e) {
            logger.error((Object)("\u4e0b\u8f7d\u591a\u5a92\u4f53\u6587\u4ef6\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage()));
            return new Media(-5, "\u672a\u77e5\u5931\u8d25\uff01");
        }
    }

    public static final boolean checkSignature(String token, String signature, String timestamp, String nonce) {
        ArrayList<String> params = new ArrayList<String>();
        params.add(token);
        params.add(timestamp);
        params.add(nonce);
        Collections.sort(params, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        String temp = (String)params.get(0) + (String)params.get(1) + (String)params.get(2);
        return DigestUtils.sha1Hex((String)temp).equals(signature);
    }
}

