/*
 * Decompiled with CFR 0.152.
 */
package cc.jinglupeng.wechat.api;

import cc.jinglupeng.wechat.api.BaseAPI;
import cc.jinglupeng.wechat.api.GroupAPI;
import cc.jinglupeng.wechat.api.MenuAPI;
import cc.jinglupeng.wechat.api.MessageAPI;
import cc.jinglupeng.wechat.api.OAuth2API;
import cc.jinglupeng.wechat.api.QrcodeAPI;
import cc.jinglupeng.wechat.api.URLAPI;
import cc.jinglupeng.wechat.api.UserAPI;
import cc.jinglupeng.wechat.bean.group.Group;
import cc.jinglupeng.wechat.bean.media.Media;
import cc.jinglupeng.wechat.bean.media.MediaId;
import cc.jinglupeng.wechat.bean.menu.Menu;
import cc.jinglupeng.wechat.bean.message.MessageType;
import cc.jinglupeng.wechat.bean.message.mass.Article;
import cc.jinglupeng.wechat.bean.message.mass.MassStatus;
import cc.jinglupeng.wechat.bean.message.mass.MsgId;
import cc.jinglupeng.wechat.bean.message.send.CustomMessage;
import cc.jinglupeng.wechat.bean.oauth.OAuthAccessToken;
import cc.jinglupeng.wechat.bean.oauth.OAuthUser;
import cc.jinglupeng.wechat.bean.qrcoe.Qrcode;
import cc.jinglupeng.wechat.bean.user.User;
import cc.jinglupeng.wechat.bean.user.Users;
import cc.jinglupeng.wechat.consts.MediaType;
import java.io.File;
import java.util.List;

public class WeChatAPI {
    private String appId;

    private WeChatAPI(String appId) {
        this.appId = appId;
    }

    public static WeChatAPI getAPI(String appId) {
        return new WeChatAPI(appId);
    }

    public String getAccessToken() {
        return BaseAPI.getAccessToken(this.appId);
    }

    public MediaId uploadMedia(File file, MediaType type) {
        MediaId mediaId = BaseAPI.uploadMedia(this.appId, file, type);
        if (mediaId == null || !mediaId.isSuccess()) {
            return null;
        }
        return mediaId;
    }

    public Media downMedia(String mediaId) {
        Media media = BaseAPI.downMedia(this.appId, mediaId);
        if (media == null || !media.isSuccess()) {
            return null;
        }
        return media;
    }

    public final boolean checkSignature(String token, String signature, String timestamp, String nonce) {
        return BaseAPI.checkSignature(token, signature, timestamp, nonce);
    }

    public Group createGroup(String name) {
        return GroupAPI.createGroup(this.appId, name);
    }

    public List<Group> getGroups() {
        return GroupAPI.getGroups(this.appId);
    }

    public String getUserGroupId(String openId) {
        return GroupAPI.getUserGroupId(this.appId, openId);
    }

    public boolean updateGroup(Group group) {
        return GroupAPI.updateGroup(this.appId, group);
    }

    public boolean moveMemberGroup(String openId, String groupId) {
        return GroupAPI.moveMemberGroup(this.appId, openId, groupId);
    }

    public Menu getMenu() {
        return MenuAPI.getMenu(this.appId);
    }

    public Boolean deleteMenu() {
        return MenuAPI.deleteMenu(this.appId);
    }

    public Boolean createMenu(String menu) {
        return MenuAPI.createMenu(this.appId, menu);
    }

    public boolean sendCustomMessage(String message) {
        return MessageAPI.sendCustomMessage(this.appId, message).isSuccess();
    }

    public boolean sendCustomMessage(CustomMessage message, String openId) {
        return MessageAPI.sendCustomMessage(this.appId, message, openId).isSuccess();
    }

    public MsgId sendMassMessage(MessageType type, String mediaId) {
        MsgId msgId = MessageAPI.sendMassMessage(this.appId, type, mediaId);
        if (msgId == null || !msgId.isSuccess()) {
            return null;
        }
        return msgId;
    }

    public MsgId sendMassMessage(MessageType type, String mediaId, List<String> openIds) {
        MsgId msgId = MessageAPI.sendMassMessage(this.appId, type, mediaId, openIds);
        if (msgId == null || !msgId.isSuccess()) {
            return null;
        }
        return msgId;
    }

    public MsgId sendMassMessage(MessageType type, String mediaId, String groupId) {
        MsgId msgId = MessageAPI.sendMassMessage(this.appId, type, mediaId, groupId);
        if (msgId == null || !msgId.isSuccess()) {
            return null;
        }
        return msgId;
    }

    public MediaId uploadNews(List<Article> articles) {
        MediaId mediaId = MessageAPI.uploadNews(this.appId, articles);
        if (mediaId == null || !mediaId.isSuccess()) {
            return null;
        }
        return mediaId;
    }

    public MediaId uploadVideo(String mediaId, String title, String description) {
        MediaId media_Id = MessageAPI.uploadVideo(this.appId, mediaId, title, description);
        if (media_Id == null || !media_Id.isSuccess()) {
            return null;
        }
        return media_Id;
    }

    public MsgId previewMessage(MessageType type, String mediaId, String openId) {
        MsgId msgId = MessageAPI.preview(this.appId, type, mediaId, openId);
        if (msgId == null || !msgId.isSuccess()) {
            return null;
        }
        return msgId;
    }

    public boolean deleteMessage(String msgId) {
        return MessageAPI.delete(this.appId, msgId).isSuccess();
    }

    public boolean queryMessageStatus(String msgId) {
        MassStatus status = MessageAPI.queryStatus(this.appId, msgId);
        if (status == null || !status.isSuccess()) {
            return false;
        }
        return status.getMsg_status().equals("SEND_SUCCESS");
    }

    public String generateOAuth2BaseUrl(String uri) {
        return OAuth2API.generateOAuth2BaseUrl(this.appId, uri);
    }

    public String generateOAuth2UserInfoUrl(String uri) {
        return OAuth2API.generateOAuth2UserInfoUrl(this.appId, uri);
    }

    public OAuthAccessToken getOAuthAccessToken(String code) {
        OAuthAccessToken accessToken = OAuth2API.getAccessToken(this.appId, code);
        if (accessToken == null || !accessToken.isSuccess()) {
            return null;
        }
        return accessToken;
    }

    public String getOpenIdByCode(String code) {
        OAuthAccessToken accessToken = OAuth2API.getAccessToken(this.appId, code);
        if (accessToken == null || !accessToken.isSuccess()) {
            return null;
        }
        return accessToken.getOpenid();
    }

    public OAuthAccessToken refreshAccessToken(String refreshToken) {
        OAuthAccessToken accessToken = OAuth2API.refreshAccessToken(this.appId, refreshToken);
        if (accessToken == null || !accessToken.isSuccess()) {
            return null;
        }
        return accessToken;
    }

    public OAuthUser getOAuthUserInfo(String accessToken, String openId) {
        OAuthUser user = OAuth2API.getUserInfo(accessToken, openId);
        if (user == null || !user.isSuccess()) {
            return null;
        }
        return user;
    }

    public Qrcode createQrcode(Integer sceneId, Integer seconds) {
        Qrcode qrcode = QrcodeAPI.createQrcode(this.appId, sceneId, seconds);
        if (qrcode == null || !qrcode.isSuccess()) {
            return null;
        }
        return qrcode;
    }

    public String getQrCodeURL(String ticket) {
        return QrcodeAPI.getQrCodeURL(ticket);
    }

    public String toShortUrl(String longUrl) {
        return URLAPI.toShort(this.appId, longUrl);
    }

    public User getUserInfo(String openId) {
        User user = UserAPI.getUserInfo(this.appId, openId);
        if (user == null || !user.isSuccess()) {
            return null;
        }
        return user;
    }

    public boolean updateUserRemark(String openId, String remark) {
        return UserAPI.updateUserRemark(this.appId, openId, remark);
    }

    public Users getUserList(String nextOpenId) {
        Users users = UserAPI.getUserList(this.appId, nextOpenId);
        if (users == null || !users.isSuccess()) {
            return null;
        }
        return users;
    }
}

