/*
 * Decompiled with CFR 0.152.
 */
package cc.jinglupeng.wechat.api;

import cc.jinglupeng.wechat.api.BaseAPI;
import cc.jinglupeng.wechat.bean.user.User;
import cc.jinglupeng.wechat.bean.user.Users;
import cc.jinglupeng.wechat.util.WxHttpUtils;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;

public class UserAPI {
    private static Logger logger = Logger.getLogger(UserAPI.class);
    private static final String USER_INFO_URL = "https://api.weixin.qq.com/cgi-bin/user/info?access_token=ACCESS_TOKEN&openid=OPENID&lang=zh_CN";
    private static final String UPDATE_USER_REMARK = "https://api.weixin.qq.com/cgi-bin/user/info/updateremark?access_token=ACCESS_TOKEN";
    private static final String GET_USER_LIST = "https://api.weixin.qq.com/cgi-bin/user/get?access_token=ACCESS_TOKEN";
    private static final String GET_USER_LIST1 = "https://api.weixin.qq.com/cgi-bin/user/get?access_token=ACCESS_TOKEN&next_openid=NEXT_OPENID";

    public static User getUserInfo(String appId, String openId) {
        String token = BaseAPI.getAccessToken(appId);
        if (token == null) {
            logger.error((Object)"\u83b7\u53d6\u7528\u6237\u57fa\u672c\u4fe1\u606f\u5931\u8d25\uff0c\u83b7\u53d6AccessToken\u5931\u8d25!");
            return new User(-4, "\u83b7\u53d6AccessToken\u5931\u8d25");
        }
        String url = USER_INFO_URL.replace("ACCESS_TOKEN", token).replace("OPENID", openId);
        try {
            return WxHttpUtils.get(url, User.class);
        }
        catch (Exception e) {
            logger.error((Object)("\u83b7\u53d6\u7528\u6237\u57fa\u672c\u4fe1\u606f\u5931\u8d25, \u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage()));
            return new User(-5, "\u672a\u77e5\u9519\u8bef\uff01");
        }
    }

    public static boolean updateUserRemark(String appId, String openId, String remark) {
        String token = BaseAPI.getAccessToken(appId);
        if (token == null) {
            logger.error((Object)"\u8bbe\u7f6e\u5907\u6ce8\u540d\u5931\u8d25\uff0c\u83b7\u53d6AccessToken\u5931\u8d25!");
            return false;
        }
        String url = UPDATE_USER_REMARK.replace("ACCESS_TOKEN", token);
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"openid", (Object)openId);
            jsonObject.put((Object)"remark", (Object)remark);
            String json = jsonObject.toString();
            json = WxHttpUtils.post(url, json);
            jsonObject = JSONObject.fromObject((Object)json);
            int errcode = jsonObject.getInt("errcode");
            if (errcode == 0) {
                return true;
            }
            logger.error((Object)("\u8bbe\u7f6e\u5907\u6ce8\u540d\u5931\u8d25\uff0c\u9519\u8bef\u7801\uff1a" + errcode));
            return false;
        }
        catch (Exception e) {
            logger.error((Object)("\u8bbe\u7f6e\u5907\u6ce8\u540d\u5931\u8d25, \u9519\u8bef\u4fe1\u606f:" + e.getMessage()));
            return false;
        }
    }

    public static Users getUserList(String appId, String nextOpenId) {
        String token = BaseAPI.getAccessToken(appId);
        if (token == null) {
            logger.error((Object)"\u83b7\u53d6\u5173\u6ce8\u8005\u5217\u8868\u5931\u8d25\uff0c\u83b7\u53d6AccessToken\u5931\u8d25!");
            return new Users(-4, "\u83b7\u53d6AccessToken\u5931\u8d25");
        }
        String url = null;
        url = nextOpenId == null ? GET_USER_LIST.replaceAll("ACCESS_TOKEN", token) : GET_USER_LIST1.replaceAll("ACCESS_TOKEN", token).replaceAll("NEXT_OPENID", nextOpenId);
        try {
            String json = WxHttpUtils.get(url);
            JSONObject jsonObject = JSONObject.fromObject((Object)json);
            if (jsonObject.containsKey((Object)"errcode")) {
                Integer errcode = jsonObject.getInt("errcode");
                logger.error((Object)("\u83b7\u53d6\u5173\u6ce8\u8005\u5217\u8868\u5931\u8d25\uff0c\u9519\u8bef\u7801\uff1a" + errcode));
                return new Users(errcode, jsonObject.getString("errmsg"));
            }
            int total = jsonObject.getInt("total");
            int count = jsonObject.getInt("count");
            String next_openid = jsonObject.getString("next_openid");
            jsonObject = jsonObject.getJSONObject("data");
            JSONArray jsonArray = jsonObject.getJSONArray("openid");
            String[] openIds = new String[jsonArray.size()];
            int length = jsonArray.size();
            for (int i = 0; i < length; ++i) {
                openIds[i] = jsonArray.getString(i);
            }
            Users users = new Users(0, "ok");
            users.setCount(count);
            users.setTotal(total);
            users.setOpenIds(openIds);
            users.setNext_openid(next_openid);
            return users;
        }
        catch (Exception e) {
            logger.error((Object)("\u83b7\u53d6\u5173\u6ce8\u8005\u5217\u8868\u5931\u8d25, \u9519\u8bef\u4fe1\u606f:" + e.getMessage()));
            return null;
        }
    }
}

