/*
 * Decompiled with CFR 0.152.
 */
package cc.jinglupeng.wechat.api;

import cc.jinglupeng.wechat.api.BaseAPI;
import cc.jinglupeng.wechat.bean.qrcoe.Qrcode;
import cc.jinglupeng.wechat.util.WxHttpUtils;
import java.net.URLEncoder;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;

public class QrcodeAPI {
    private static Logger logger = Logger.getLogger(QrcodeAPI.class);
    private static final String CREATE_QRCODE_URL = "https://api.weixin.qq.com/cgi-bin/qrcode/create?access_token=ACCESS_TOKEN";
    private static final String SHOW_QRCODE_URL = "https://mp.weixin.qq.com/cgi-bin/showqrcode?ticket=TICKET";

    public static Qrcode createQrcode(String appId, Integer sceneId, Integer seconds) {
        JSONObject jsonObject = new JSONObject();
        if (sceneId == null || sceneId <= 0) {
            sceneId = 1;
        }
        String action_name = null;
        if (seconds == null || seconds == 0) {
            action_name = "QR_LIMIT_SCENE";
            if (sceneId > 100000) {
                sceneId = 100000;
            }
        } else {
            action_name = "QR_SCENE";
            jsonObject.put((Object)"expire_seconds", (Object)seconds);
            if (seconds > 1800) {
                seconds = 1800;
            }
            if (seconds <= 0) {
                seconds = 0;
            }
        }
        JSONObject jsonObject2 = new JSONObject();
        JSONObject jsonObject3 = new JSONObject();
        jsonObject3.put((Object)"scene_id", (Object)(sceneId + ""));
        jsonObject2.put((Object)"scene", (Object)jsonObject3);
        jsonObject.put((Object)"action_name", (Object)action_name);
        jsonObject.put((Object)"action_info", (Object)jsonObject2);
        String json = jsonObject.toString();
        String token = BaseAPI.getAccessToken(appId);
        if (token == null) {
            logger.error((Object)"\u521b\u5efa\u4e8c\u7ef4\u7801ticket\u5931\u8d25\uff0c\u83b7\u53d6AccessToken\u5931\u8d25!");
            return new Qrcode(-4, "\u83b7\u53d6AccessToken\u5931\u8d25");
        }
        String url = CREATE_QRCODE_URL.replaceAll("ACCESS_TOKEN", token);
        try {
            return WxHttpUtils.post(url, json, Qrcode.class);
        }
        catch (Exception e) {
            logger.error((Object)("\u521b\u5efa\u4e8c\u7ef4\u7801ticket\u5931\u8d25, \u9519\u8bef\u4fe1\u606f:" + e.getMessage()));
            return new Qrcode(-5, "\u672a\u77e5\u9519\u8bef");
        }
    }

    public static String getQrCodeURL(String ticket) {
        try {
            ticket = URLEncoder.encode(ticket, "UTF-8");
            return SHOW_QRCODE_URL.replace("TICKET", ticket);
        }
        catch (Exception e) {
            logger.error((Object)("\u901a\u8fc7ticket\u6362\u53d6\u4e8c\u7ef4\u7801\u5931\u8d25, \u9519\u8bef\u4fe1\u606f:" + e.getMessage()));
            return null;
        }
    }
}

