package cc.jinglupeng.wechat.util;

import net.sf.json.JSONObject;

/**
 * 提供微信 API 所需的 JSON 的序列化和解析方法，该类中的所有方法不耦合微信 API。
 * 
 * @author jinglupeng.cc
 */
public class JSONUtil {

	/**
	 * 将一个对象序列化为 JSON
	 * 
	 * @param obj
	 * @return
	 */
	public final static String serialize(Object obj) {
		JSONObject json = JSONObject.fromObject(obj);
		return json.toString(1);
	}

	/**
	 * 将字符转解析为指定类型的对象。
	 * 
	 * @param json
	 * @param klass
	 * @return 成功返回 传入类的实例，失败返回 null
	 */
	@SuppressWarnings("unchecked")
	public final static <T> T parse(String json, Class<T> klass) {
		T t = null;
		try {
			JSONObject jsonObject = JSONObject.fromObject(json);
			return (T) JSONObject.toBean(jsonObject, klass);
		} catch (Exception e) {
			t = null;
		}
		return t;
	}

}
