package cc.jinglupeng.wechat.consts;

import java.io.File;

/**
 * 
 * @author Lupeng
 * @version 1.0
 * @since 1.0
 * 
 */
public enum MediaType {
	image, voice, video, thumb;

	public Long limitSize;

	public Long getLimitSize() {
		switch (this) {
		case image:
			return 1024 * 1024l;
		case voice:
			return 2 * 1024 * 1024l;
		case video:
			return 10 * 1024 * 1024l;
		case thumb:
			return 64 * 1024l;
		default:
			return 0l;
		}
	}

	/**
	 * 判断上传的文件是否超过大小限制
	 * 
	 * @param file
	 * @return
	 * @since 1.0
	 */
	public boolean checkSizeLimit(File file) {
		Long size = getLimitSize();
		Long length = file.length();
		if (size >= length) {
			return true;
		}
		return false;
	}
}
