package cc.jinglupeng.wechat.bean.user;

import cc.jinglupeng.wechat.bean.Status;
import cc.jinglupeng.wechat.util.JSONUtil;

/**
 * 用户信息
 * 
 * @author jinglupeng.cc
 */
public class User extends Status {

	private static final long serialVersionUID = 1L;

	public User() {
		super();
	}

	public User(Integer errcode, String errmsg) {
		super(errcode, errmsg);
	}

	private short subscribe; // 用户是否订阅该公众号标识，值为0时，代表此用户没有关注该公众号，拉取不到其余信息。
	private String openid; // 用户的标识，对当前公众号唯一
	private String nickname; // 用户的昵称
	private short sex; // 用户的性别，值为1时是男性，值为2时是女性，值为0时是未知
	private String language; // 用户的语言，简体中文为zh_CN
	private String province; // 用户所在省份
	private String city; // 用户所在城市
	private String country; // 用户所在国家
	private String headimgurl; // 用户头像，最后一个数值代表正方形头像大小（有0、46、64、96、132数值可选，0代表640*640正方形头像），用户没有头像时该项为空
	private Long subscribe_time; // 用户关注时间，为时间戳。如果用户曾多次关注，则取最后关注时间

	private String unionid; // 只有在用户将公众号绑定到微信开放平台帐号后，才会出现该字段。详见：获取用户个人信息（UnionID机制）

	public short getSubscribe() {
		return subscribe;
	}

	public void setSubscribe(short subscribe) {
		this.subscribe = subscribe;
	}

	public String getOpenid() {
		return openid;
	}

	public void setOpenid(String openid) {
		this.openid = openid;
	}

	public String getNickname() {
		return nickname;
	}

	public void setNickname(String nickname) {
		this.nickname = nickname;
	}

	public short getSex() {
		return sex;
	}

	public void setSex(short sex) {
		this.sex = sex;
	}

	public String getLanguage() {
		return language;
	}

	public void setLanguage(String language) {
		this.language = language;
	}

	public String getProvince() {
		return province;
	}

	public void setProvince(String province) {
		this.province = province;
	}

	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getCountry() {
		return country;
	}

	public void setCountry(String country) {
		this.country = country;
	}

	public String getHeadimgurl() {
		return headimgurl;
	}

	public void setHeadimgurl(String headimgurl) {
		this.headimgurl = headimgurl;
	}

	public Long getSubscribe_time() {
		return subscribe_time;
	}

	public void setSubscribe_time(Long subscribe_time) {
		this.subscribe_time = subscribe_time;
	}

	@Override
	public String toString() {
		return JSONUtil.serialize(this);
	}

	public String getUnionid() {
		return unionid;
	}

	public void setUnionid(String unionid) {
		this.unionid = unionid;
	}

}
