package cc.jinglupeng.wechat.bean.message.send;

import net.sf.json.JSONObject;

import org.dom4j.DocumentHelper;
import org.dom4j.Element;

/**
 * 语音消息
 * 
 * @author jinglupeng.cc
 */
public class Voice implements CustomMessage, PassiveMessage {

	private static final long serialVersionUID = 1L;
	private final String msgType = "voice";

	private String media_id; // 发送的语音的媒体ID

	public Voice() {
	}

	public Voice(String mediaId) {
		this.media_id = mediaId;
	}

	public String getMedia_id() {
		return media_id;
	}

	public void setMedia_id(String media_id) {
		this.media_id = media_id;
	}

	@Override
	public String toXML(String toUserName, String fromUserName, int createTime) {
		Element root = DocumentHelper.createElement("xml");
		root.addElement("ToUserName").addCDATA(toUserName);
		root.addElement("FromUserName").addCDATA(fromUserName);
		root.addElement("CreateTime").addCDATA(createTime + "");
		root.addElement("MsgType").addCDATA(msgType);
		root.addElement("Voice").addElement("MediaId").addCDATA(getMedia_id());
		return root.asXML();
	}

	@Override
	public String toJSON(String touser) {
		JSONObject json = new JSONObject();
		json.put("touser", touser);
		json.put("msgtype", msgType);
		JSONObject json1 = new JSONObject();
		json1.put("media_id", getMedia_id());
		json.put("voice", json1);
		return json.toString();
	}

}
